package com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder;


import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import com.easesource.iot.protoparser.gaeadcu.model.CustFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;

import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

public class XFBRequestEncoder extends BaseRequestEncoder {

    @Override
    protected DcuMessage assemblyMessage(List<DataItem> dataItems, DataCommand cmd, DcuMessage msg) {
        //设置asdu部分
        byte[] data ;
        ByteBuf buf = ByteBufAllocator.DEFAULT.directBuffer();
        try {
            DataItem dataItem = dataItems.get(0);
            CustFile file = dataItem.getFile();
            byte[] content = file.getReadContent();
            data = new byte[XFBDATA_LEN + content.length];
            buf.writeByte(TYPE_UPDATEFILE_DWONLOAD);
            buf.writeByte(COT_REPLY);
            buf.writeBytes(BytesUtil.byteToByte(BytesUtil.intToBytes(file.getFileId())));
            buf.writeBytes(BytesUtil.byteToByte(BytesUtil.intToBytes(file.getStartPos())));
            buf.writeBytes(BytesUtil.byteToByte(BytesUtil.intToBytes(file.getReadLen())));
            //不需要反向
            buf.writeBytes(file.getReadContent());
            buf.readBytes(data);
            msg.setData(data);
            return msg;
        }finally {
            ReferenceCountUtil.release(buf);
        }
    }
}
