package com.easesource.iot.protoparser.gaeadcu.message;


import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.base.utils.ParseUtils;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Arrays;
import java.util.List;
import static com.easesource.iot.protoparser.gaeadcu.constant.Constants.*;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DcuMessage implements IMessage<DcuMessage> {
    /**
     * 报文总长度
     */
    private int length;
    /**
     * 功能编码
     */
    private byte function;
    /**
     * 序列号
     */
    private short seq;
    /**
     * 终端地址
     */
    private int rtuId;
    /**
     * 规约数据部分
     */
    private byte[] data;

    /**
     * 是否下行，默认上行
     */
    private boolean transDown = false;
    /**
     * 下行命令ID
     */
    private long transDownCommandId;
    /**
     * 下行报文数量
     */
    private int transDownCount;
    /**
     * 下行通讯方式
     */
    private int transDownType;

    //DcuMessage中加入DataItem信息
    private List<DataItem> dataItemList;

    public static String generatePrimaryKey(int rtuId) {
        return DCU_PROTOCOL_TAG + PK_DELIMITED + HexDump.toHex(rtuId);
    }
    public DcuMessage(){
    }
    public static DcuMessage createHeartMessage(int dcuId) {
        DcuMessage heartMessage = new DcuMessage();
        heartMessage.setLength(HEAD_LEN);
        heartMessage.setRtuId(dcuId);
        heartMessage.setSeq((short) 0);
        heartMessage.setFunction((byte) 0x81);
        heartMessage.setTransDown(true);
        return heartMessage;
    }

    @Override
    public boolean isTransDown() {
        return transDown;
    }

    public void setTransDown(boolean transDown) {
        this.transDown = transDown;
    }


    public long getTransDownCommandId() {
        return transDownCommandId;
    }

    public void setTransDownCommandId(long transDownCommandId) {
        this.transDownCommandId = transDownCommandId;
    }

    public int getTransDownCount() {
        return transDownCount;
    }

    public void setTransDownCount(int transDownCount) {
        this.transDownCount = transDownCount;
    }

    public int getTransDownType() {
        return transDownType;
    }

    public void setTransDownType(int transDownType) {
        this.transDownType = transDownType;
    }

    public int getLength() {
        return length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public byte getFunction() {
        return function;
    }

    public void setFunction(byte function) {
        this.function = function;
    }

    public short getSeq() {
        return seq;
    }

    public void setSeq(short seq) {
        this.seq = seq;
    }

    public List<DataItem> getDataItemList() {
        return dataItemList;
    }

    public void setDataItemList(List<DataItem> dataItemList) {
        this.dataItemList = dataItemList;
    }

    @Override
    public int getRtuId() {
        return rtuId;
    }

    public void setRtuId(int rtuId) {
        this.rtuId = rtuId;
    }

    public byte[] getData() {
        return data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getFrameType() {
        return ParseUtils.readBit(function, 0);
    }

    public int getEncryptType() {
        return (function & 0x30) >>> 4;
    }

    public Boolean getTransDown(){
        if((function&0x80) == 128){
            transDown = true;
            return  transDown;
        }
        return transDown;
    }
    @Override
    public DcuMessage createConfirmMessage() {
        DcuMessage confirmMessage = null;
        //心跳确认
        if (getFunction() == FUNCTION_CODE_HEART) {
            confirmMessage = new DcuMessage();
            confirmMessage.setLength(HEAD_LEN);
            confirmMessage.setSeq(getSeq());
            confirmMessage.setRtuId(getRtuId());
            confirmMessage.setTransDown(true);
            confirmMessage.setFunction(FUNCTION_CODE_HEART_CONFIRM);
        }
        //需要确认
        if (ParseUtils.readBit(getFunction(), 6) == 1) {
            byte[] data = new byte[]{ASDU_TYPE_CONFIRM, ASDU_COT_CONFIRM};
            confirmMessage = new DcuMessage();
            confirmMessage.setLength(HEAD_LEN + data.length);
            confirmMessage.setSeq(getSeq());
            confirmMessage.setRtuId(getRtuId());
            confirmMessage.setTransDown(true);
            confirmMessage.setFunction(FUNCTION_CODE_DATAUP_CONFIRM);
            confirmMessage.setData(data);
        }
        return confirmMessage;
    }

    @Override
    public String getPrimaryKey() {
        return DCU_PROTOCOL_TAG + PK_DELIMITED + HexDump.toHex(rtuId);
    }

    @Override
    public String getProtocolName() {
        return DCU_PROTOCOL;
    }


//    @Override
//    public String toString() {
//        return "DcuMessage{" +
//            "length=" + length +
//            ", function=" + function +
//            ", seq=" + seq +
//            ", rtuId=" + rtuId +
//            ", data=" + Arrays.toString(data) +
//            ", transDown=" + transDown +
//            ", transDownCommandId=" + transDownCommandId +
//            ", transDownCount=" + transDownCount +
//            ", transDownType=" + transDownType +
//            ", dataItemList=" + dataItemList +
//            '}';
//    }


    @Override
    public String toString() {
        return "DcuMessage{" +
            "length=" + length +
            ", function=" + function +
            ", seq=" + seq +
            ", rtuId=" + rtuId +
            ", data=" + Arrays.toString(data) +
            ", transDown=" + transDown +
            ", transDownCommandId=" + transDownCommandId +
            ", transDownCount=" + transDownCount +
            ", transDownType=" + transDownType +
            ", dataItemList=" + dataItemList +
            '}';
    }
}
