package com.easesource.iot.protoparser.gaeadcu.message;

import java.io.Serializable;

/**
 * 规约消息对象
 *
 * @param <T>
 */
public interface IMessage<T extends IMessage> extends Serializable {

    /**
     * 生成回复消息
     *
     * @return
     */
    T createConfirmMessage();

    /**
     * 获取终端ID
     *
     * @return
     */
    int getRtuId();

    /**
     * 是否下行
     *
     * @return
     */
    boolean isTransDown();

    /**
     * 获取规约消息主键标识
     *
     * @return
     */
    String getPrimaryKey();

    /**
     * 获取规约名称
     *
     * @return
     */
    String getProtocolName();
}
