package com.easesource.iot.protoparser.gaeadcu.message.asdu;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 规约业务数据对象
 */
public class DataCommand {
    private final byte function;
    private final short seq;
    private final int rtuId;
    private final List<DataItem> items = new ArrayList<DataItem>();
    /**
     * 命令ID
     */
    private Long id;
    /**
     * 主站操作任务ID
     */
    private Long taskId;
    /**
     * 消息数量。命令可能被拆分成多个消息下发
     */
    private int messageCount;
    /**
     * 下发时间
     */
    private Date requestTime;
    /**
     * 回应时间
     */
    private Date responseTime;

    private String status;
    private String code;
    //标识类型
    private byte type;
    //传送原因
    private byte cot;


    public DataCommand(byte function, short seq, int rtuId) {
        this.function = function;
        this.type = function;
        this.seq = seq;
        this.rtuId = rtuId;
    }

    public byte getFunction() {
        return function;
    }

    public short getSeq() {
        return seq;
    }

    public int getRtuId() {
        return rtuId;
    }

    public void addItem(DataItem item) {
        Assert.notNull(item, "[Assertion failed] - this argument DataItem is required; it must not be null");
        items.add(item);
    }

    public List<DataItem> getItems() {
        return items;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public byte getType() {
        return type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte getCot() {
        return cot;
    }

    public void setCot(byte cot) {
        this.cot = cot;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public int getMessageCount() {
        return messageCount;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public Date getRequestTime() {
        return requestTime;
    }

    public void setRequestTime(Date requestTime) {
        this.requestTime = requestTime;
    }

    public Date getResponseTime() {
        return responseTime;
    }

    public void setResponseTime(Date responseTime) {
        this.responseTime = responseTime;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}
