package com.easesource.iot.protoparser.gaeadcu.message.asdu;

import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBus;
import com.easesource.iot.protoparser.gaeadcu.model.CustFile;
import com.easesource.iot.protoparser.gaeadcu.model.Task;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 规约业务数据项
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class DataItem {
    /**
     * 参数设置结果：设置成功
     */
    public static final int STATUS_SUCCESS = 0;
    /**
     * 参数设置结果：不确定
     */
    public static final int STATUS_AMBIGUOUS = 1;
    /**
     * 参数设置结果：设置失败
     */
    public static final int STATUS_FAILED = 2;
    //命令ID
    private Long commandId;
    //读数值
    private String value;
    private int status;
    private Date time;
    //表计地址
    private String channel;
    //信号点号
    private String tn;
    //标识类型
    private String code;
    //传送原因
    private byte cot;
    private byte q;
    //数据类型
    private String type;
    private String cause;
    //新增属性
    //RS485
    private byte portName;
    //波特率
    private byte baudRate;
    //校验
    private byte parity;
    //停止位
    private byte stopBites;
    //0X06 表示字符串长度
    private short stringLen;
    //组号
    private byte groupNumber;
    private DataCommand itemCommand;
    private Map<String, Object> attributes;
    private MBus mBus;
    //任务
    private Task task;
    //任务数
    private byte taskNum;
    //加密方法
    private byte encrypitype;
    //加密密码
    private String passWord;
    //配置类型
    private byte conftype;
    //配置内容
    private short conflength;
    //参数个数
    private byte paramNum;

    //参数编码
    private byte param;

    //二字节整型value
    private short paramShort;
    //代理端口
    private short port;
    //有效时间
    private int duration;

    private CustFile file;

    public CustFile getFile() {
        return file;
    }

    public void setFile(CustFile file) {
        this.file = file;
    }

    public short getParamShort() {
        return paramShort;
    }

    public void setParamShort(short paramShort) {
        this.paramShort = paramShort;
    }

    public Task getTask() {
        return task;
    }

    public void setTask(Task task) {
        this.task = task;
    }


    public short getPort() {
        return port;
    }

    public void setPort(short port) {
        this.port = port;
    }

    public int getDuration() {
        return duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public byte getParam() {
        return param;
    }

    public void setParam(byte param) {
        this.param = param;
    }

    public byte getParamNum() {
        return paramNum;
    }

    public void setParamNum(byte paramNum) {
        this.paramNum = paramNum;
    }


    public byte getConftype() {
        return conftype;
    }

    public void setConftype(byte conftype) {
        this.conftype = conftype;
    }

    public short getConflength() {
        return conflength;
    }

    public void setConflength(short conflength) {
        this.conflength = conflength;
    }

    public byte getEncrypitype() {
        return encrypitype;
    }

    public void setEncrypitype(byte encrypitype) {
        this.encrypitype = encrypitype;
    }

    public String getPassWord() {
        return passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public byte getTaskNum() {
        return taskNum;
    }

    public void setTaskNum(byte taskNum) {
        this.taskNum = taskNum;
    }


    public byte getGroupNumber() {
        return groupNumber;
    }

    public void setGroupNumber(byte groupNumber) {
        this.groupNumber = groupNumber;
    }


    public short getStringLen() {
        return stringLen;
    }

    public void setStringLen(short stringLen) {
        this.stringLen = stringLen;
    }

    public MBus getmBus() {
        return mBus;
    }

    public void setmBus(MBus mBus) {
        this.mBus = mBus;
    }

    public Long getCommandId() {
        return commandId;
    }

    public void setCommandId(Long commandId) {
        this.commandId = commandId;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getTn() {
        return tn;
    }

    public void setTn(String tn) {
        this.tn = tn;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public byte getCot() {
        return cot;
    }

    public void setCot(byte cot) {
        this.cot = cot;
    }

    public String getCause() {
        return cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public byte getQ() {
        return q;
    }

    public void setQ(byte q) {
        this.q = q;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DataCommand getItemCommand() {
        return itemCommand;
    }

    public void setItemCommand(DataCommand itemCommand) {
        this.itemCommand = itemCommand;
    }

    public Map<String, Object> getAttributes() {
        return attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setAttribute(String key, Object value) {
        if (attributes == null) {
            attributes = new HashMap<String, Object>();
        }
        attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (attributes != null) {
            return attributes.get(key);
        }
        return null;
    }

    public byte getPortName() {
        return portName;
    }

    public void setPortName(byte portName) {
        this.portName = portName;
    }

    public byte getBaudRate() {
        return baudRate;
    }

    public void setBaudRate(byte baudRate) {
        this.baudRate = baudRate;
    }

    public byte getParity() {
        return parity;
    }

    public void setParity(byte parity) {
        this.parity = parity;
    }

    public byte getStopBites() {
        return stopBites;
    }

    public void setStopBites(byte stopBites) {
        this.stopBites = stopBites;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.DEFAULT_STYLE);
    }

    //用于输出解析数据
    public String printDataItem() {
        return "DataItem{" +
            "commandId=" + commandId +
            ", value='" + value + '\'' +
            ", status=" + status +
            ", time=" + time +
            ", channel='" + channel + '\'' +
            ", tn='" + tn + '\'' +
            ", code='" + code + '\'' +
            ", cot=" + cot +
            ", q=" + q +
            ", type='" + type + '\'' +
            ", cause='" + cause + '\'' +
            ", portName=" + portName +
            ", baudRate=" + baudRate +
            ", parity=" + parity +
            ", stopBites=" + stopBites +
            ", itemCommand=" + itemCommand +
            ", attributes=" + attributes +
            ", mBus=" + mBus +
            '}';
    }

}
