package com.easesource.iot.protoparser.gaeadcu.packagedata;

import com.easesource.commons.util.StringUtils;
import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.base.utils.FileUtil;
import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MBus;
import com.easesource.iot.protoparser.cjt188.v2004.mbus.MData;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import com.easesource.iot.protoparser.gaeadcu.model.CustFile;
import com.easesource.iot.protoparser.gaeadcu.model.Task;
import com.easesource.iot.protoparser.gaeadcu.util.SecurityUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PackageData {

    public static DcuMessage heartData(DcuMessage msg){
        msg.setLength(12);
        msg.setFunction((byte)1);
        msg.setSeq((short) 0);
        msg.setRtuId(295109480);
        return msg;
    }
    public static  DcuMessage packageF901Data(DcuMessage msg){
        //组装报头数据
        msg.setLength(38);
        msg.setFunction((byte)128);
        msg.setSeq((short) 43);
        msg.setRtuId(295109480);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem =new DataItem();
        MBus mBus = new MBus();
        MData mData = new MData();
        mData.setSign("1f90");
        mData.setSER((byte)0);
        mBus.setmData(mData);
        mBus.settCode("20");
        mBus.setSite("00201507202115");
        mBus.setCol("01");
        //通过控制码获得
        //mBus.setLength(3);
        //校验码通过计算获得
        //mBus.setCheckCode("A4");
        dataItem.setmBus(mBus);
        dataItem.setCode("F9");
        dataItem.setPortName((byte)1);
        dataItem.setBaudRate((byte)2);
        dataItem.setParity((byte)0);
        dataItem.setStopBites((byte) 0);
        dataItem.setCot((byte)6);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }
    public static  DcuMessage packageF904Data(DcuMessage msg){
        //组装报头数据
        msg.setLength(38);
        msg.setFunction((byte)128);
        msg.setSeq((short) 43);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem =new DataItem();
        MBus mBus = new MBus();
        MData mData = new MData();
        mData.setSign("1f90");
        mData.setSER((byte)0);
        mData.setValveStatus("55");
        mBus.setmData(mData);
        mBus.settCode("20");
        mBus.setSite("00201507181500");
        mBus.setCol("04");
        //mBus.setLength(3);
        dataItem.setmBus(mBus);
        dataItem.setCode("F9");
        dataItem.setPortName((byte)1);
        dataItem.setBaudRate((byte)2);
        dataItem.setParity((byte)0);
        dataItem.setStopBites((byte) 0);
        dataItem.setCot((byte)6);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }
    public static DcuMessage package02Data(DcuMessage msg){
        msg.setLength(21);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
         DataItem dataItem = new DataItem();
         dataItem.setCode("02");
         dataItem.setCot((byte)6);
         dataItem.setTime(new Date());
         list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }
    public static DcuMessage package03Data(DcuMessage msg){
        msg.setLength(25);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("03");
        dataItem.setCot((byte)6);
        //待完成
        dataItem.setChannel("3B1810000089");
        dataItem.setTn("020A0114");
        dataItem.setValue("80");
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }
    public static DcuMessage package04Data(DcuMessage msg){
        msg.setLength(28);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("04");
        dataItem.setCot((byte)6);
        //待完成
        dataItem.setChannel("3B1810000089");
        dataItem.setTn("020A0114");
        dataItem.setValue("224.84");
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }
    public static DcuMessage package05Data(DcuMessage msg){
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(295109209);
        msg.setTransDown(true);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("05");
        dataItem.setCot((byte)6);
        dataItem.setChannel("2B1907000259");
        //遥测发送间隔:00000001
        dataItem.setTn("00000001");
        //要求是正整数
        dataItem.setValue("289");
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }
    public static DcuMessage package06Data(DcuMessage msg){
        msg.setLength(26+2);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("06");
        dataItem.setCot((byte)6);
        //待完成
        dataItem.setChannel("3B1810000089");
        dataItem.setTn("020A0114");
        dataItem.setStringLen((short)2);
        dataItem.setValue("ab");
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package07Data(DcuMessage msg){
        msg.setLength(14);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("07");
        dataItem.setCot((byte)6);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package08Data(DcuMessage msg){
        msg.setLength(20);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("08");
        dataItem.setCot((byte)5);
        dataItem.setChannel("3B1810000089");
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package09Data(DcuMessage msg){
//        msg.setLength(14);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(295109209);
        msg.setTransDown(true);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("09");
        dataItem.setCot((byte)5);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }
    public static DcuMessage package10Data(DcuMessage msg){
        msg.setLength(14);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("10");
        dataItem.setCot((byte)5);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package20Data(DcuMessage msg){
        msg.setLength(20);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("20");
        dataItem.setCot((byte)5);
        dataItem.setChannel("3B1810000089");
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package21Data(DcuMessage msg){
        msg.setLength(21);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("21");
        dataItem.setCot((byte)5);
        dataItem.setChannel("3B1810000089");
        dataItem.setGroupNumber((byte)255);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }
    public static DcuMessage package22Data(DcuMessage msg){
        msg.setLength(29);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("22");
        dataItem.setCot((byte)5);
        dataItem.setTaskNum((byte) 1);
          Task task = new Task();
          task.setMeterId("3B1810000089");
          task.setTaskNo((byte)1);
          task.setFrozenParam((byte)1);
          task.setSendPatram((byte)1);
          task.setNum((byte)1);
           List<String> signList = new ArrayList<>();
           signList.add("00000000");
           task.setSignList(signList);
          dataItem.setTask(task);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package23Data(DcuMessage msg){
        msg.setLength(22);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("23");
        dataItem.setCot((byte)5);
        dataItem.setTaskNum((byte) 1);
        Task task = new Task();
        task.setMeterId("3B1810000089");
        task.setTaskNo((byte)1);
        dataItem.setTask(task);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package25Data(DcuMessage msg){
        msg.setLength(37);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("25");
        dataItem.setCot((byte)5);
        dataItem.setTaskNum((byte) 1);
        Task task = new Task();
        task.setMeterId("000000000000");
        task.setTaskNo((byte)1);
        task.setStartTime(new Date());
        task.setEndTime(new Date());
        task.setInterval((byte)1);
        dataItem.setTask(task);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package26Data(DcuMessage msg){
        msg.setLength(23);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("26");
        dataItem.setCot((byte)5);
        dataItem.setTaskNum((byte)1);
        Task task = new Task();
        task.setMeterId("000000000000");
        task.setTaskNo((byte)1);
        task.setInterval((byte)1);
        dataItem.setTask(task);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }
    public static DcuMessage package27Data(DcuMessage msg){
        msg.setLength(22);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("27");
        dataItem.setCot((byte)5);
        dataItem.setTaskNum((byte)1);
        Task task = new Task();
        task.setMeterId("000000000000");
        task.setTaskNo((byte)1);
        dataItem.setTask(task);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package80Data(DcuMessage msg){
        msg.setLength(20);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("80");
        dataItem.setCot((byte)6);
        dataItem.setChannel("3B1810000089");
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package82Data(DcuMessage msg){
        msg.setLength(47);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("82");
        dataItem.setCot((byte)6);
        dataItem.setEncrypitype((byte)0);
        dataItem.setPassWord("abcdefghijklnmopqrstuvwxyzwzbwzb");
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package83Data(DcuMessage msg){
        msg.setLength(18);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("83");
        dataItem.setCot((byte)6);
        dataItem.setConftype((byte)1);
        dataItem.setConflength((short)1);
        dataItem.setValue("a");
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package84Data(DcuMessage msg){
        msg.setLength(15);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("84");
        dataItem.setCot((byte)5);
        dataItem.setConftype((byte)1);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package85Data(DcuMessage msg){
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(295109209);
        msg.setTransDown(true);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("85");
        dataItem.setCot((byte)5);
        dataItem.setParamNum((byte)1);
        dataItem.setParam((byte)1);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage package86Data(DcuMessage msg){
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(295109209);
        msg.setTransDown(true);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("86");
        dataItem.setCot((byte)5);
        dataItem.setParamNum((byte)1);
        //00000001 表示遥测发送间隔
        dataItem.setParam((byte)1);
        dataItem.setParamShort((short)600);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }


    public static DcuMessage package88Data(DcuMessage msg){
        msg.setLength(14);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("88");
        dataItem.setCot((byte)7);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage packageF8Data(DcuMessage msg){
        msg.setLength(20);
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(1635780317);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("F8");
        dataItem.setCot((byte)6);
        dataItem.setPort((short) 1000);
        dataItem.setDuration(2323);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

    public static DcuMessage packageFAData(DcuMessage msg) throws IOException {
        msg.setFunction((byte)128);
        msg.setSeq((short) 0);
        msg.setRtuId(295109209);
        msg.setTransDown(true);
        List<DataItem> list = new ArrayList<>();
        DataItem dataItem = new DataItem();
        dataItem.setCode("FA");
        dataItem.setCot((byte)6);
        String path = "C:\\Users\\Administrator\\Desktop\\V5.25-EMT-621-24MHz.bin";
        byte[] allFile = FileUtil.readBytesFromFile(path);
        CustFile file = new CustFile();
        file.setFileId(667);
        file.setFileSize((int)FileUtil.getFileSize(path));
        file.setReadContent(SecurityUtil.calculateMd5(allFile));
        file.setFileVersion(StringUtils.leftPad("V5.25",16," "));
        file.setFileName(StringUtils.leftPad("V5.25-EMT-621-24MHz.bin",32," "));
        dataItem.setFile(file);
        list.add(dataItem);
        msg.setDataItemList(list);
        return msg;
    }

//    public static DcuMessage packageFBData(DcuMessage msg){
//        msg.setFunction((byte)128);
//        msg.setSeq((short) 0);
//        msg.setRtuId(295109209);
//        msg.setTransDown(true);
//        List<DataItem> list = new ArrayList<>();
//        DataItem dataItem = new DataItem();
//        dataItem.setCode("FB");
//        dataItem.setCot((byte)5);
//        DataItem.FileData fileData = dataItem.new FileData();
//        fileData.setFileId(110);
//        fileData.setStartPos(11);
//        fileData.setReadLen(2);
//        list.add(dataItem);
//        msg.setDataItemList(list);
//        return msg;
//    }

    public static void main(String[] args) throws IOException {
//        String path = "C:\\Users\\Administrator\\Documents\\WeChat Files\\wangzhibin5796\\FileStorage\\CustFile\\2019-11\\V5.25-EMT-621-24MHz.bin";
////        byte[] b = SecurityUtil.calculateMd5(FileUtil.readBytesFromFile(path));
////        for(byte data:b){
////            System.out.println(HexDump.toHex(data));
////        }
//        byte[] b = BytesUtil.ASCIIToNBytes("           ",32);
//        for(byte data:b){
//            System.out.println(HexDump.toHex(data));
//        }
        byte[] b = BytesUtil.ASCIIToBytes(StringUtils.leftPad("V5.25-EMT-621-24MHz.bin", 32, ' '));
        for(byte data:b){
            System.out.println(HexDump.toHex(data));
        }
//        String path = "C:\\Users\\Administrator\\Documents\\WeChat Files\\wangzhibin5796\\FileStorage\\CustFile\\2019-11\\V5.25-EMT-621-24MHz.bin";
//        DataItem dataItem = new DataItem();
//        byte[] allFile = FileUtil.readBytesFromFile(path);
//        dataItem.setAttribute("READ_CONTENT",allFile);
//        byte[] a = (byte[])dataItem.getAttribute("READ_CONTENT");
//        for(byte b:a){
//            System.out.println(b);
//        }
    }
}
