package com.easesource.iot.protoparser.gaeadcu.task;

import com.easesource.iot.protoparser.base.cache.DcuIdChannelCache;
import com.easesource.iot.protoparser.base.thread.handler.IThreadEventHandler;
import com.easesource.iot.protoparser.base.thread.handler.ThreadPool;
import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.gaeadcu.handler.codec.encoder.RequestEncoder;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataCommand;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import io.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import javax.annotation.PostConstruct;
import java.util.List;

@Component
public class PostmanHandler extends ThreadPool<DcuMessage> implements IThreadEventHandler<DcuMessage>,IPostmanHandler {
    private final Logger log = LoggerFactory.getLogger(getClass());

    public PostmanHandler(){
        threadEventHandler = this;
    }

    @PostConstruct
    @Override
    public boolean start(){
        super.init();
        return super.start();
    }

    @Override
    public void handleEvent(DcuMessage dcuMessage) throws Exception {
        log.info("主站发起下发命令");
        if (dcuMessage != null) {
                DataCommand cmd = null;
                List<DataItem> list = null;
                // 注意：这里第一个参数就是标识类型,而不是之前的控制码，所以得从web参数中获得 ， test中 可以自己设置实参
                if (dcuMessage.getDataItemList() != null) {
                    cmd = new DataCommand(BytesUtil.StringTobyte(dcuMessage.getDataItemList().get(0).getCode()), dcuMessage.getSeq(), dcuMessage.getRtuId());
                    cmd.setCot(dcuMessage.getDataItemList().get(0).getCot());
                    list = dcuMessage.getDataItemList();
                }
            int cruId = dcuMessage.getRtuId();
            if(cmd != null && list != null){
                byte type = cmd.getType();
                //组装数据
                RequestEncoder encoder = new RequestEncoder();
                dcuMessage = encoder.encode(type , list , cmd , dcuMessage);
            }
            Channel channel = DcuIdChannelCache.getKeyCache(cruId);
            log.info("{} 连接是否存在： {}", cruId, channel != null);
            if(channel != null){
                if(channel.isWritable() && channel.isActive()){
                    channel.writeAndFlush(dcuMessage);
                }
            }
            }
    }

    @Override
    public boolean isNeedNewThread(DcuMessage o) {
        return true;
    }

    @Override
    public void handle(DcuMessage msg) {
        this.offer(msg);
    }

}
