package com.easesource.iot.protoparser.gaeadcu.task;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.gateway.base.sender.RabbitSender;
import com.easesource.iot.protoparser.base.thread.handler.IThreadEventHandler;
import com.easesource.iot.protoparser.base.thread.handler.ThreadPool;
import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import com.easesource.iot.protoparser.gaeadcu.message.asdu.DataItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;

import java.util.List;
import java.util.stream.Collectors;

import static com.easesource.iot.gateway.base.model.MqConstants.*;

@Component
public class SendToRabbitmqHandler extends ThreadPool<DcuMessage> implements IThreadEventHandler<DcuMessage>, ISendToRabbitmqHandler {

    private final Logger log = LoggerFactory.getLogger(getClass());

    @Resource
    private RabbitSender rabbitSender;

    public SendToRabbitmqHandler(){
        threadEventHandler = this;
    }

    @Override
    @PostConstruct
    public boolean start(){
        super.init();
        return super.start();
    }

    @Override
    public void handleEvent(DcuMessage o) throws Exception {
        if(o != null) {
            /*if(log.isInfoEnabled() && StringUtils.equalsAnyIgnoreCase(HexDump.toHex(o.getRtuId()), "401012A0")) {
                log.info("逻辑地址：" + HexDump.toHex(o.getRtuId()));
                log.info("DcuMessage dataitem size : " + (o.getDataItemList() != null ? o.getDataItemList().size() : 0));
                List<DataItem> dataItemList = o.getDataItemList();
                if(dataItemList != null && dataItemList.size() > 0) {
                    List<DataItem> list = dataItemList.stream().filter(dataItem -> dataItem.getChannel().equals("000000008026")).collect(Collectors.toList());
                    list.forEach(d -> log.info(JsonConvertUtils.convertToString(d)));
                }
            }*/
            if(o.getDataItemList() != null && o.getDataItemList().size() > 0) {
                String code = o.getDataItemList().get(0).getCode();
                //只处理F9召测上来消息，对于11数据当作心跳处理。
                if("F9".equals(code)) {
                    log.info("终端{} 表计 {} 上送消息", o.getRtuId(), o.getDataItemList().get(0).getChannel());
                    rabbitSender.sendMessage(TOPIC_EXCHANGE, TOPIC_KEY_F9, o);
                }
                if("11".equals(code)) {
                    /*if(log.isInfoEnabled()) {
                        if(StringUtils.equals(HexDump.toHex(o.getRtuId()), "700205E8")) {
                            log.info("逻辑地址：" + HexDump.toHex(o.getRtuId()));
                            log.info("DcuMessage : " + JsonConvertUtils.convertToString(o.getDataItemList()));
                        }
                    }*/
                    log.info("终端{} 表计 {} 上送消息", o.getRtuId(), o.getDataItemList().get(0).getChannel());
                    rabbitSender.sendMessage(DIRECT_DCU_EXCHANGE1, DIRECT_KEY_DCU11, o);
                }
                if("FA".equals(code) || "FB".equals(code)) {
                    rabbitSender.sendMessage(DIRECT_EXCHANGE, DIRECT_KEY1, o);
                }
            }
            else {
                //log.info("逻辑地址：" + HexDump.toHex(o.getRtuId()));
                //log.error("DcuMessage's getDataItemList is null.");
            }
        }
        else {
            log.error("DcuMessage is null.");
        }
    }

    @Override
    public boolean isNeedNewThread(DcuMessage o) {
        return true;
    }

    @Override
    public void handleAndSend(DcuMessage msg) {
          this.offer(msg);
    }
}
