package com.easesource.iot.protoparser.gaeadcu.task;

import com.alibaba.fastjson.JSONObject;
import com.easesource.iot.gateway.base.sender.RedisSender;
import com.easesource.iot.protoparser.base.thread.handler.IThreadEventHandler;
import com.easesource.iot.protoparser.base.thread.handler.ThreadPool;
import com.easesource.iot.protoparser.gaeadcu.message.DcuMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

import static com.easesource.iot.gateway.base.model.MqConstants.*;

@Component
public class SendToRedisHandler extends ThreadPool<DcuMessage> implements IThreadEventHandler<DcuMessage>, ISendToRabbitmqHandler {

    private final Logger log = LoggerFactory.getLogger(getClass());

    @Resource
    private RedisSender redisSender;

    public SendToRedisHandler(){
        threadEventHandler = this;
    }

    @Override
    @PostConstruct
    public boolean start(){
        super.init();
        return super.start();
    }

    @Override
    public void handleEvent(DcuMessage o) throws Exception {
        if(o != null) {
            if(o.getDataItemList() != null && o.getDataItemList().size() > 0) {
                String code = o.getDataItemList().get(0).getCode();
                //只处理F9召测上来消息，对于11数据当作心跳处理。
                if("F9".equals(code)) {
                    log.info("终端{} 表计 {} 上送消息", o.getRtuId(), o.getDataItemList().get(0).getChannel());

                    redisSender.sendMessage(TOPIC_KEY_F9, JSONObject.toJSONString(o));
                }
                if("11".equals(code)) {
                    log.info("终端{} 表计 {} 上送消息", o.getRtuId(), o.getDataItemList().get(0).getChannel());
                    redisSender.sendMessage(DIRECT_KEY_DCU11, JSONObject.toJSONString(o));
                }
                if("FA".equals(code) || "FB".equals(code)) {
                    redisSender.sendMessage(DIRECT_KEY1, JSONObject.toJSONString(o));
                }
            }
            else {
                //log.info("逻辑地址：" + HexDump.toHex(o.getRtuId()));
                //log.error("DcuMessage's getDataItemList is null.");
            }
        }
        else {
            log.error("DcuMessage is null.");
        }
    }

    @Override
    public boolean isNeedNewThread(DcuMessage o) {
        return true;
    }

    @Override
    public void handleAndSend(DcuMessage msg) {
          this.offer(msg);
    }
}
