package com.easesource.iot.protoparser.gaeadcu.task;

import com.easesource.iot.protoparser.base.thread.handler.IThreadEventHandler;
import com.easesource.iot.protoparser.base.thread.handler.ThreadPool;
import com.easesource.iot.protoparser.base.utils.FormatWriter;
import com.easesource.iot.protoparser.base.utils.HexDump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.PostConstruct;

public class WriterToUpFile extends ThreadPool<byte[]> implements IThreadEventHandler<byte[]>, IWriterToFile {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    public WriterToUpFile() {
        threadEventHandler = this;
    }

    @PostConstruct
    @Override
    public boolean start() {
        super.init();
        return super.start();
    }

    @Override
    public void handleEvent(byte[] o) throws Exception {
        byte[] tranDown = new byte[1];
        System.arraycopy(o, 0, tranDown, 0, 1);
        byte[] rtuId = new byte[4];
        System.arraycopy(o, 1, rtuId, 0, 4);
        int length = o.length - 4 - 1;
        byte[] array = new byte[length];
        System.arraycopy(o, 5, array, 0, length);
        if(tranDown[0] == 1) {
            FormatWriter.upData(HexDump.hexNoSpaceDump(rtuId), array);
        }
        else if(tranDown[0] == 0) {
            FormatWriter.downData(HexDump.hexNoSpaceDump(rtuId), array);
        }

    }

    @Override
    public boolean isNeedNewThread(byte[] o) {
        return true;
    }

    @Override
    public void handle(byte[] data) {
        this.offer(data);
    }

}
