package com.easesource.iot.protoparser.gaeadcu.util;


import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

public class SecurityUtil {
    private static final Object LOCK = new Object();
    private static MessageDigest messageDigestMd5;

    // DES加密
    public static byte[] desEncrypt(byte[] data, byte[] key) throws Exception {
        // DESKeySpec desKey = new DESKeySpec(key);
        // SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        // SecretKey securekey = keyFactory.generateSecret(desKey);
        SecretKeySpec securekey = new SecretKeySpec(key, "DES");
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");// ECB/PKCS5Padding
        cipher.init(Cipher.ENCRYPT_MODE, securekey);
        return cipher.doFinal(data);
    }

    // DES解密
    public static byte[] desDecrypt(byte[] data, byte[] key) throws Exception {
        // DESKeySpec desKey = new DESKeySpec(key);
        // SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        // SecretKey securekey = keyFactory.generateSecret(desKey);
        SecretKeySpec securekey = new SecretKeySpec(key, "DES");
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");// DES/ECB/PKCS5Padding
        cipher.init(Cipher.DECRYPT_MODE, securekey);
        return cipher.doFinal(data);
    }

    // AES加密
    public static byte[] aesEncrypt(byte[] raw, byte[] key) throws Exception {
        SecretKeySpec securekey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");// "算法/模式/补码方式"AES/ECB/PKCS5Padding
        cipher.init(Cipher.ENCRYPT_MODE, securekey);
        return cipher.doFinal(raw);
    }

    // AES解密
    public static byte[] aesDecrypt(byte[] raw, byte[] key) throws Exception {
        SecretKeySpec securekey = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");// AES/ECB/PKCS5Padding
        cipher.init(Cipher.DECRYPT_MODE, securekey);
        return cipher.doFinal(raw);
    }

    // AES加密
    public static byte[] aesEncrypt2(byte[] content, byte[] password) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(password);
        kgen.init(128, secureRandom);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");// 创建密码器
        cipher.init(Cipher.ENCRYPT_MODE, key);// 初始化
        return cipher.doFinal(content);
    }

    // AES解密
    public static byte[] aesDecrypt2(byte[] content, byte[] password) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(password);
        kgen.init(128, secureRandom);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");// 创建密码器
        cipher.init(Cipher.DECRYPT_MODE, key);// 初始化
        return cipher.doFinal(content);
    }

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);// [0,62)
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static String getRandomString2(int length) {
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(3);
            long result = 0;
            switch (number) {
                case 0:
                    result = Math.round(Math.random() * 25 + 65);
                    sb.append(String.valueOf((char) result));
                    break;
                case 1:
                    result = Math.round(Math.random() * 25 + 97);
                    sb.append(String.valueOf((char) result));
                    break;
                case 2:
                    sb.append(String.valueOf(new Random().nextInt(10)));
                    break;
            }
        }
        return sb.toString();
    }

    public static byte[] calculateMd5(byte[] binaryData) {
        // 采用prototype模式，提高多线程高并发下的性能
        if (messageDigestMd5 == null) {
            synchronized (LOCK) {
                if (messageDigestMd5 == null) {
                    try {
                        messageDigestMd5 = MessageDigest.getInstance("MD5");
                    } catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException("MD5 algorithm not found.");
                    }
                }
            }
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = (MessageDigest) messageDigestMd5.clone();
        } catch (CloneNotSupportedException e) {
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            } catch (NoSuchAlgorithmException e1) {
                throw new RuntimeException("MD5 algorithm not found.");
            }
        }
        messageDigest.update(binaryData);
        return messageDigest.digest();
    }


}
