/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.codec.decoder;

import com.easesource.iot.protoparser.base.message.IMessage;
import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.base.utils.ParseUtils;
import com.easesource.iot.protoparser.iec104.codec.decoder.IDataItemDecoder;
import com.easesource.iot.protoparser.iec104.constant.Constants;
import com.easesource.iot.protoparser.iec104.model.DataCommand;
import com.easesource.iot.protoparser.iec104.model.DataValue;
import com.easesource.iot.protoparser.iec104.model.Message;
import com.easesource.iot.protoparser.iec104.model.ProtocolDataConfig;
import com.easesource.iot.protoparser.iec104.model.asdu.DataItem;
import com.easesource.iot.protoparser.iec104.model.asdu.DataItemParser;
import com.easesource.iot.protoparser.iec104.model.asdu.ProtocolDataItemConfig;
import com.easesource.iot.protoparser.iec104.utils.DateUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataItemDecoder
implements IDataItemDecoder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss.S";
    private int commAddressLen = 2;
    private int infoAddressLen = 3;
    private int cotLen = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean decode(IMessage message, DataCommand hc) {
        Message msg = (Message)message;
        byte[] msgData = msg.getData();
        ByteBuf dataBuf = null;
        ByteBuf lenBuf = null;
        try {
            dataBuf = ByteBufAllocator.DEFAULT.directBuffer(msgData.length);
            dataBuf = dataBuf.writeBytes(msgData);
            byte type = dataBuf.readByte();
            String typeHex = HexDump.toHex((byte)type);
            byte determiner = dataBuf.readByte();
            byte[] cot = new byte[this.cotLen];
            dataBuf.readBytes(cot);
            byte[] commAddress = new byte[this.commAddressLen];
            dataBuf.readBytes(commAddress);
            int T = (cot[0] & 0x80) >> 7;
            int PN = (cot[0] & 0x40) >> 6;
            int YY = cot[0] & 0x3F;
            String sYY = this.GetCSYY(YY);
            sYY = sYY + " | T=" + T + " P/N=" + PN;
            boolean isAddrOrder = ParseUtils.readBit((byte)determiner, (int)7) == 1;
            int infoSize = determiner & 0x7F;
            int firstAddress = 0;
            if (isAddrOrder) {
                byte[] infoAddress = new byte[this.infoAddressLen];
                dataBuf.readBytes(infoAddress);
                firstAddress = this.getInfoAddress(infoAddress);
            }
            for (int j = 0; j < infoSize; ++j) {
                int address = 0;
                if (isAddrOrder) {
                    address = firstAddress + j;
                } else {
                    byte[] infoAddress = new byte[this.infoAddressLen];
                    dataBuf.readBytes(infoAddress);
                    address = this.getInfoAddress(infoAddress);
                }
                String data = ByteBufUtil.hexDump((ByteBuf)dataBuf).toUpperCase();
                ProtocolDataItemConfig pdc = ProtocolDataConfig.getInstance().getDataItemConfig(typeHex);
                if (pdc != null) {
                    DataValue dataValue = DataItemParser.parser(data, pdc.getFormat(), false);
                    lenBuf = dataBuf.readBytes(dataValue.getLen() / 2);
                    DataItem hcr = new DataItem();
                    hcr.setCode(typeHex);
                    hcr.setTn(String.valueOf(address));
                    hcr.setCot(cot);
                    hcr.setCause(sYY);
                    String sValue = dataValue.getValue();
                    String Q = "00";
                    if (typeHex.equals("01") || typeHex.equals("03") || typeHex.equals("1E") || typeHex.equals("1F")) {
                        if (typeHex.equals("1E") || typeHex.equals("1F")) {
                            String sDateTime = sValue.substring(sValue.indexOf("#") + 1, sValue.length());
                            hcr.setTime(DateUtils.parse(sDateTime, TIME_PATTERN));
                            sValue = sValue.substring(0, sValue.indexOf("#"));
                        }
                        int iValue = 0;
                        if (typeHex.equals("01") || typeHex.equals("1E")) {
                            iValue = (byte)Integer.parseInt(sValue.substring(0, 2), 16) & 1;
                        } else if (typeHex.equals("03") || typeHex.equals("1F")) {
                            iValue = (byte)Integer.parseInt(sValue.substring(0, 2), 16) & 3;
                        }
                        Q = this.GetPZCS(sValue.substring(0, 2));
                        sValue = Integer.toString(iValue);
                    } else if (typeHex.equals("05") || typeHex.equals("20")) {
                        if (typeHex.equals("20")) {
                            String sDateTime = sValue.substring(sValue.lastIndexOf("#") + 1, sValue.length());
                            hcr.setTime(DateUtils.parse(sDateTime, TIME_PATTERN));
                            sValue = sValue.substring(0, sValue.lastIndexOf("#"));
                        }
                        Q = sValue.substring(sValue.indexOf("#") + 1, sValue.length());
                        sValue = sValue.substring(0, sValue.indexOf("#"));
                    } else if (typeHex.equals("09")) {
                        Q = sValue.substring(sValue.indexOf("#") + 1, sValue.length());
                        sValue = sValue.substring(0, sValue.indexOf("#"));
                    } else if (typeHex.equals("0D") || typeHex.equals("24")) {
                        if (typeHex.equals("24")) {
                            String sDateTime = sValue.substring(sValue.lastIndexOf("#") + 1, sValue.length());
                            hcr.setTime(DateUtils.parse(sDateTime, TIME_PATTERN));
                            sValue = sValue.substring(0, sValue.lastIndexOf("#"));
                        }
                        Q = sValue.substring(sValue.indexOf("#") + 1, sValue.length());
                        sValue = sValue.substring(0, sValue.indexOf("#"));
                    }
                    hcr.setValue(sValue);
                    hcr.setQ((byte)Short.parseShort(Q, 16));
                    hc.addItem(hcr);
                    ((Message)message).addItem(hcr);
                }
                if (lenBuf == null) continue;
                ReferenceCountUtil.release(lenBuf);
            }
        }
        finally {
            if (dataBuf != null) {
                ReferenceCountUtil.release((Object)dataBuf);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getInfoAddress(byte[] infoAddress) {
        ByteBuf buf = null;
        try {
            buf = Unpooled.buffer();
            if (infoAddress.length < 4) {
                buf.writeBytes(infoAddress);
                buf.writeBytes(new byte[4 - infoAddress.length]);
            }
            int n = buf.order(Constants.BYTE_ORDER).readInt();
            return n;
        }
        finally {
            if (buf != null) {
                ReferenceCountUtil.release((Object)buf);
            }
        }
    }

    private String GetPZCS(String pzcs) {
        int iQ = (byte)Integer.parseInt(pzcs, 16) & 0xF0;
        return Integer.toString(iQ, 16).toUpperCase();
    }

    private String GetCSYY(int yy) {
        String sResult = "";
        switch (yy) {
            case 0: {
                sResult = "00-\u672a\u5b9a\u4e49";
                break;
            }
            case 1: {
                sResult = "01-per/cyc\u5468\u671f\u3001\u5faa\u73af";
                break;
            }
            case 2: {
                sResult = "02-back\u80cc\u666f\u626b\u63cf";
                break;
            }
            case 3: {
                sResult = "03-spont\u7a81\u53d1";
                break;
            }
            case 4: {
                sResult = "04-\u521d\u59cb\u5316";
                break;
            }
            case 5: {
                sResult = "05-\u8bf7\u6c42\u6216\u88ab\u8bf7\u6c42";
                break;
            }
            case 6: {
                sResult = "06-\u6fc0\u6d3b";
                break;
            }
            case 7: {
                sResult = "07-\u6fc0\u6d3b\u786e\u8ba4";
                break;
            }
            case 8: {
                sResult = "08-\u505c\u6b62\u6fc0\u6d3b";
                break;
            }
            case 9: {
                sResult = "09-\u505c\u6b62\u6fc0\u6d3b\u786e\u8ba4";
                break;
            }
            case 10: {
                sResult = "10-\u6fc0\u6d3b\u7ed3\u675f";
                break;
            }
            case 11: {
                sResult = "11-\u8fdc\u7a0b\u547d\u4ee4\u5f15\u8d77\u7684\u8fd4\u9001\u4fe1\u606f";
                break;
            }
            case 12: {
                sResult = "12-\u5f53\u5730\u547d\u4ee4\u5f15\u8d77\u7684\u8fd4\u9001\u4fe1\u606f";
                break;
            }
            case 13: {
                sResult = "13-\u6587\u4ef6\u4f20\u9001";
                break;
            }
            case 20: {
                sResult = "20-introgen\u54cd\u5e94\u603b\u53ec\u5524";
                break;
            }
            case 21: {
                sResult = "21-\u54cd\u5e94\u7b2c1\u7ec4\u53ec\u5524 ";
                break;
            }
            case 22: {
                sResult = "22-\u54cd\u5e94\u7b2c2\u7ec4\u53ec\u5524";
                break;
            }
            case 23: {
                sResult = "23-\u54cd\u5e94\u7b2c3\u7ec4\u53ec\u5524";
                break;
            }
            case 24: {
                sResult = "24-\u54cd\u5e94\u7b2c4\u7ec4\u53ec\u5524";
                break;
            }
            case 25: {
                sResult = "25-\u54cd\u5e94\u7b2c5\u7ec4\u53ec\u5524";
                break;
            }
            case 26: {
                sResult = "26-\u54cd\u5e94\u7b2c6\u7ec4\u53ec\u5524";
                break;
            }
            case 27: {
                sResult = "27-\u54cd\u5e94\u7b2c7\u7ec4\u53ec\u5524";
                break;
            }
            case 28: {
                sResult = "28-\u54cd\u5e94\u7b2c8\u7ec4\u53ec\u5524";
                break;
            }
            case 29: {
                sResult = "29-\u54cd\u5e94\u7b2c9\u7ec4\u53ec\u5524";
                break;
            }
            case 30: {
                sResult = "30-\u54cd\u5e94\u7b2c10\u7ec4\u53ec\u5524";
                break;
            }
            case 31: {
                sResult = "31-\u54cd\u5e94\u7b2c11\u7ec4\u53ec\u5524";
                break;
            }
            case 32: {
                sResult = "32-\u54cd\u5e94\u7b2c12\u7ec4\u53ec\u5524";
                break;
            }
            case 33: {
                sResult = "33-\u54cd\u5e94\u7b2c13\u7ec4\u53ec\u5524";
                break;
            }
            case 34: {
                sResult = "34-\u54cd\u5e94\u7b2c14\u7ec4\u53ec\u5524";
                break;
            }
            case 35: {
                sResult = "35-\u54cd\u5e94\u7b2c15\u7ec4\u53ec\u5524";
                break;
            }
            case 36: {
                sResult = "36-\u54cd\u5e94\u7b2c16\u7ec4\u53ec\u5524";
                break;
            }
            case 37: {
                sResult = "37-\u54cd\u5e94\u8ba1\u6570\u91cf\u603b\u53ec\u5524";
                break;
            }
            case 38: {
                sResult = "38-\u54cd\u5e94\u7b2c1\u7ec4\u8ba1\u6570\u91cf\u53ec\u5524";
                break;
            }
            case 39: {
                sResult = "39-\u54cd\u5e94\u7b2c2\u7ec4\u8ba1\u6570\u91cf\u53ec\u5524";
                break;
            }
            case 40: {
                sResult = "40-\u54cd\u5e94\u7b2c3\u7ec4\u8ba1\u6570\u91cf\u53ec\u5524";
                break;
            }
            case 41: {
                sResult = "41-\u54cd\u5e94\u7b2c4\u7ec4\u8ba1\u6570\u91cf\u53ec\u5524";
                break;
            }
            case 44: {
                sResult = "44-\u672a\u77e5\u7684\u7c7b\u578b\u6807\u8bc6";
                break;
            }
            case 45: {
                sResult = "45-\u672a\u77e5\u7684\u4f20\u9001\u539f\u56e0";
                break;
            }
            case 46: {
                sResult = "46-\u672a\u77e5\u7684\u5e94\u7528\u670d\u52a1\u6570\u636e\u5355\u5143\u516c\u5171\u5730\u5740";
                break;
            }
            case 47: {
                sResult = "47-\u672a\u77e5\u7684\u4fe1\u606f\u5bf9\u8c61\u5730\u5740";
                break;
            }
            case 48: {
                sResult = "48-\u9065\u63a7\u6267\u884c\u8f6f\u538b\u677f\u72b6\u6001\u9519\u8bef";
                break;
            }
            case 49: {
                sResult = "49-\u9065\u63a7\u6267\u884c\u65f6\u95f4\u6233\u9519\u8bef";
                break;
            }
            case 50: {
                sResult = "50-\u9065\u63a7\u6267\u884c\u6570\u5b57\u7b7e\u540d\u8ba4\u8bc1\u9519\u8bef";
                break;
            }
            case 63: {
                sResult = "63-\u81ea\u5b9a\u4e49\u5de5\u51b5\u6570\u636e";
                break;
            }
            default: {
                sResult = "00-\u672a\u5b9a\u4e49";
            }
        }
        return sResult;
    }
}

