/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.codec.encoder;

import com.easesource.iot.protoparser.base.message.IMessage;
import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.iec104.codec.encoder.IDataItemEncoder;
import com.easesource.iot.protoparser.iec104.model.DataCommand;
import com.easesource.iot.protoparser.iec104.model.Message;
import com.easesource.iot.protoparser.iec104.model.asdu.DataItem;
import com.easesource.iot.protoparser.iec104.utils.DateCoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItemEncoder
implements IDataItemEncoder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public IMessage encode(List<DataItem> items, DataCommand cmd, Message msg) {
        byte[] data = new byte[]{};
        for (int i = 0; i < items.size(); ++i) {
            byte[] q;
            byte[] tn;
            byte[] DataMarker;
            DataItem dataItem = items.get(i);
            String typeHex = dataItem.getCode();
            byte[] code = BytesUtil.stringToByte((String)typeHex);
            byte[] value = new byte[]{};
            byte[] sigleValue = new byte[]{};
            if (typeHex.equals("32")) {
                DataMarker = DataItemEncoder.dataMarker(msg, dataItem);
                tn = BytesUtil.intTotn3Bytes((String)dataItem.getTn());
                value = BytesUtil.float2byte((float)Float.valueOf(dataItem.getValue()).floatValue());
                q = new byte[]{0};
                sigleValue = BytesUtil.byte4Merger((byte[])DataMarker, (byte[])tn, (byte[])value, (byte[])q);
            } else if (typeHex.equals("2D")) {
                DataMarker = DataItemEncoder.dataMarker(msg, dataItem);
                tn = BytesUtil.intTotn3Bytes((String)dataItem.getTn());
                byte[] sco = BytesUtil.stringToByte((String)dataItem.getValue());
                sigleValue = BytesUtil.byte3Merger((byte[])DataMarker, (byte[])tn, (byte[])sco);
            } else if (typeHex.equals("2E")) {
                DataMarker = DataItemEncoder.dataMarker(msg, dataItem);
                tn = BytesUtil.intTotn3Bytes((String)dataItem.getTn());
                byte[] dco = BytesUtil.stringToByte((String)dataItem.getValue());
                sigleValue = BytesUtil.byte3Merger((byte[])DataMarker, (byte[])tn, (byte[])dco);
            } else if (typeHex.equals("70")) {
                DataMarker = DataItemEncoder.dataMarker(msg, dataItem);
                tn = BytesUtil.intTotn3Bytes((String)dataItem.getTn());
                value = BytesUtil.float2byte((float)Float.valueOf(dataItem.getValue()).floatValue());
                q = new byte[]{0};
                sigleValue = BytesUtil.byte4Merger((byte[])DataMarker, (byte[])tn, (byte[])value, (byte[])q);
            } else if (typeHex.equals("6A")) {
                DataMarker = DataItemEncoder.dataMarker(msg, dataItem);
                tn = new byte[]{0, 0, 0};
                value = DateCoder.getCP16Time2a(dataItem.getValue());
                sigleValue = BytesUtil.byte3Merger((byte[])DataMarker, (byte[])tn, (byte[])value);
            } else if (typeHex.equals("7A")) {
                DataMarker = DataItemEncoder.dataMarker(msg, dataItem);
                tn = BytesUtil.intTotn3Bytes((String)dataItem.getTn());
                value = BytesUtil.hexStringTobytes((String)dataItem.getValue(), (String)"#");
                q = new byte[]{0};
                sigleValue = BytesUtil.byte4Merger((byte[])DataMarker, (byte[])tn, (byte[])value, (byte[])q);
            }
            data = BytesUtil.byte3Merger((byte[])data, (byte[])code, (byte[])sigleValue);
        }
        msg.setFunction((byte)0);
        msg.setData(data);
        msg.setTransDown(true);
        return msg;
    }

    private static byte[] dataMarker(Message msg, DataItem dataItem) {
        byte[] determiner = new byte[]{1};
        byte[] cot = dataItem.getCot();
        byte[] rtuId = BytesUtil.shortToBytes((short)((short)msg.getRtuId()));
        byte[] markerData = BytesUtil.byte3Merger((byte[])determiner, (byte[])cot, (byte[])rtuId);
        return markerData;
    }
}

