/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.constant;

import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Constants {
    public static final String IEC104_PROTOCOL = "IEC104M";
    public static final String CW104_PROTOCOL = "CW104";
    public static final String PK_DELIMITED = "|";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final byte HEAD_SIGN = 104;
    public static final int HEADER_FRAME_LENGTH = 2;
    public static final int CTRL_FRAME_LENGTH = 4;
    public static final int HEAD_LEN = 6;
    public static final int LOGIN_LENGTH = 14;
    public static final byte[] CW_LOGIN_BYTES = new byte[]{-1, -1, -1, -1};
    public static final byte[] LOGIN_ADDRESS_BYTES = new byte[]{0, 0, 0, 0};
    public static final byte[] LOGIN_BYTES_1 = new byte[]{70, 1, 4, 0};
    public static final byte[] LOGIN_BYTES_2 = new byte[]{0, 0, 0, 4};
    public static final int TRANSDOWN_FRAME_LENGTH = 6;
    public static final int APCI_LENGTH = 6;
    public static final int STATE_DONE = 1;
    public static final int STATE_UNDO = 0;
    public static final String MEASURETAG_STATE = "GEN_STATE";
    public static final String STATE_OFFLINE = "1";
    public static final String STATE_ONLINE = "0";
    public static final int FRAME_U = 3;
    public static final int FRAME_S = 1;
    public static final int FRAME_I = 0;
    public static final int S_U_RTUADDRESS = -10;
    public static final byte FUNCTION_SUBSTATION_LOGIN = 5;
    public static final byte FUNCTION_SUBSTATION_LOGIN_CW = 6;
    public static final byte FUNCTION_CODE_I = 0;
    public static final byte FUNCTION_CODE_S = 1;
    public static final byte FUNCTION_CODE_U_STARTDT_ACT = 7;
    public static final byte FUNCTION_CODE_U_STARTDT_CON = 11;
    public static final byte FUNCTION_CODE_U_STOPDT_ACT = 19;
    public static final byte FUNCTION_CODE_U_STOPDT_CON = 35;
    public static final byte FUNCTION_CODE_U_TESTFR_ACT = 67;
    public static final byte FUNCTION_CODE_U_TESTFR_CON = -125;
    public static final byte FUNCTION_CODE_S_SEND = -95;
    public static final byte FUNCTION_CODE_U_STARTDT_ACT_SEND = -94;
    public static final byte FUNCTION_CODE_U_STARTDT_CON_SEND = -93;
    public static final byte FUNCTION_CODE_U_STOPDT_ACT_SEND = -92;
    public static final byte FUNCTION_CODE_U_STOPDT_CON_SEND = -91;
    public static final byte FUNCTION_CODE_U_TESTFR_ACT_SEND = -90;
    public static final byte FUNCTION_CODE_U_TESTFR_CON_SEND = -89;
    public static final byte TYPE_ALL_CALL = 100;
    public static final byte DETERMINER_ALL_CALL = 20;
    public static final int ITEM_STATUS_SUCCESS = 0;
    public static final int ITEM_STATUS_AMBIGUOUS = 1;
    public static final int ITEM_STATUS_FAILED = 2;
    public static final String STATUS_RUNNING = "0";
    public static final String STATUS_SUCCESS = "1";
    public static final String STATUS_RTU_FAILED = "2";
    public static final String STATUS_COMM_FAILED = "3";
    public static final String STATUS_TIMEOUT = "4";
    public static final String STATUS_FWD_CMD_NO_RESPONSE = "5";
    public static final String STATUS_PARA_INVALID = "6";
    public static final String STATUS_PERMISSION_DENIDE = "7";
    public static final String STATUS_ITEM_INVALID = "8";
    public static final String STATUS_TIME_OVER = "9";
    public static final String STATUS_TARGET_UNREACHABLE = "10";
    public static final String STATUS_SEND_FAILURE = "11";
    public static final String STATUS_SMS_OVERFLOW = "12";
    public static final String STATUS_PRAR_ERROR = "13";
    public static final String STATUS_PARSE_ERROR = "14";
    public static final String STATUS_TODB_ERROR = "15";
    public static final String STATUS_RTUAMTCOM_ERROR = "16";
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss.S";
    public static Map<Byte, Byte> TRANSDOWN_FUNCTION_CODE_MAP;

    public static final boolean containsFunction(byte function) {
        return TRANSDOWN_FUNCTION_CODE_MAP.containsKey(function);
    }

    public static final byte getTransDownFunction(byte function) {
        byte transDownFunction = -1;
        if (TRANSDOWN_FUNCTION_CODE_MAP.containsKey(function)) {
            transDownFunction = TRANSDOWN_FUNCTION_CODE_MAP.get(function);
        }
        return transDownFunction;
    }

    static {
        HashMap<Byte, Byte> transDownFunctionMap = new HashMap<Byte, Byte>();
        transDownFunctionMap.put((byte)1, (byte)-95);
        transDownFunctionMap.put((byte)7, (byte)-94);
        transDownFunctionMap.put((byte)11, (byte)-93);
        transDownFunctionMap.put((byte)19, (byte)-92);
        transDownFunctionMap.put((byte)35, (byte)-91);
        transDownFunctionMap.put((byte)67, (byte)-90);
        transDownFunctionMap.put((byte)-125, (byte)-89);
        TRANSDOWN_FUNCTION_CODE_MAP = Collections.unmodifiableMap(transDownFunctionMap);
    }
}

