/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.handler.read;

import com.easesource.iot.protoparser.base.cache.ChannelIdRtuIdCache;
import com.easesource.iot.protoparser.base.cache.ChannelIpPortCache;
import com.easesource.iot.protoparser.base.cache.DcuIdChannelCache;
import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.iec104.codec.decoder.DataItemDecoder;
import com.easesource.iot.protoparser.iec104.constant.Constants;
import com.easesource.iot.protoparser.iec104.model.DataCommand;
import com.easesource.iot.protoparser.iec104.model.Message;
import com.easesource.iot.protoparser.iec104.task.WriterToFile;
import com.easesource.iot.protoparser.iec104.utils.WriterUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="MessageSocketReadHandler")
@ChannelHandler.Sharable
public class MessageReadHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final Logger log = LoggerFactory.getLogger(MessageReadHandler.class);
    public static ChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private DataCommand cmd;
    @Autowired
    private DataItemDecoder decoder;
    @Autowired
    private WriterToFile writerToFile;
    private int commAddressLen = 2;
    private int infoAddressLen = 3;
    private int cotLen = 2;

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        byte[] arr = null;
        if (this.log.isDebugEnabled()) {
            ByteBuf buf = in.copy();
            int len = buf.readableBytes();
            arr = new byte[len];
            buf.readBytes(arr);
            this.log.debug("First Decoder>>>>>>>" + HexDump.hexDump((byte[])arr));
            if (buf != null) {
                ReferenceCountUtil.release((Object)buf);
            }
        }
        Channel incoming = ctx.channel();
        Message message = new Message();
        in.readByte();
        short length = in.readUnsignedByte();
        message.setLength(length);
        int function = this.readFrame(in, length, message);
        Boolean flag = message.isTransDown();
        if (message.getRtuId() != 0) {
            this.writerToFile.handle(WriterUtils.getBytes(flag, message.getRtuId(), arr));
            this.log.debug("\u903b\u8f91\u5730\u5740>>>>>>>" + message.getRtuId());
            DcuIdChannelCache.putCache((Integer)message.getRtuId(), (Channel)incoming);
            ChannelIdRtuIdCache.putCache((String)incoming.id().toString(), (Integer)message.getRtuId());
        }
        if (ChannelIdRtuIdCache.getKeyCache((String)incoming.id().toString()) != null) {
            this.writerToFile.handle(WriterUtils.getBytes(flag, ChannelIdRtuIdCache.getKeyCache((String)incoming.id().toString()), arr));
        }
        if (function >= 0 && function == 6) {
            function = 5;
            int rtu = message.getRtuId();
            ByteBuf dataBuf = Unpooled.buffer();
            dataBuf.writeBytes(Constants.LOGIN_BYTES_1);
            dataBuf.order(Constants.BYTE_ORDER).writeShort(rtu);
            dataBuf.writeBytes(Constants.LOGIN_BYTES_2);
            message.setData(dataBuf.array());
            message.setAddress(Constants.LOGIN_ADDRESS_BYTES);
        }
        message.setFunction((byte)function);
        Message confirmMessage = message.createConfirmMessage();
        if (confirmMessage != null && incoming.isWritable() && incoming != null) {
            incoming.writeAndFlush((Object)confirmMessage);
            this.log.debug("\u5fc3\u8df3\u786e\u8ba4>>>>>>>" + incoming.id().toString());
        }
        ctx.fireChannelRead((Object)message);
    }

    private byte readFrame(ByteBuf in, short length, Message message) {
        int function = -1;
        byte[] bytes = new byte[4];
        in.getBytes(in.readerIndex(), bytes);
        message.setAddress(bytes);
        if (length == 14 && Arrays.equals(bytes, Constants.CW_LOGIN_BYTES)) {
            function = 6;
            message.setSendSeq(0);
            message.setRecvSeq(0);
            in.readBytes(bytes);
            byte[] data = new byte[length - 4];
            in.readBytes(data);
            int rtua = this.getRtua(data[8], data[9]);
            message.setRtuId(rtua);
            return (byte)function;
        }
        byte c1 = in.readByte();
        byte c2 = in.readByte();
        byte c3 = in.readByte();
        byte c4 = in.readByte();
        int type = c1 & 1;
        if (type == 1) {
            type = c1 & 3;
        }
        switch (type) {
            case 0: {
                function = 0;
                message.setFunction((byte)function);
                int sendSeq = this.getSeq(c1, c2);
                int recvSeq = this.getSeq(c3, c4);
                message.setSendSeq(sendSeq);
                message.setRecvSeq(recvSeq);
                byte[] data = new byte[length - 4];
                in.getBytes(in.readerIndex(), data);
                message.setData(data);
                int rtua = 0;
                if (this.commAddressLen == 1) {
                    rtua = data[2 + this.cotLen] & 0xFF;
                } else if (this.commAddressLen == 2) {
                    rtua = this.getRtua(data[2 + this.cotLen], data[3 + this.cotLen]);
                }
                message.setRtuId(rtua);
                if (data != null) {
                    this.cmd = new DataCommand(message.getFunction(), (short)message.getRecvSeq(), message.getRtuId());
                    this.decoder.decode(message, this.cmd);
                }
                if (length != 14 || !Arrays.equals(bytes, Constants.LOGIN_ADDRESS_BYTES) || !Arrays.equals(Arrays.copyOfRange(data, 0, 4), Constants.LOGIN_BYTES_1) || !Arrays.equals(Arrays.copyOfRange(data, 6, 10), Constants.LOGIN_BYTES_2)) break;
                message.setFunction((byte)5);
                function = 5;
                break;
            }
            case 1: {
                if (length == 6) {
                    function = -95;
                    byte b1 = in.readByte();
                    byte b2 = in.readByte();
                    message.setRtuId(this.getRtua(b1, b2));
                } else {
                    function = 1;
                }
                int iRecvSeq = this.getSeq(c3, c4);
                message.setRecvSeq(iRecvSeq);
                break;
            }
            case 3: {
                if (length == 6) {
                    byte b1 = in.readByte();
                    byte b2 = in.readByte();
                    message.setRtuId(this.getRtua(b1, b2));
                }
                function = this.readUFrameFunction(c1, length, message);
                break;
            }
        }
        return (byte)function;
    }

    private int getRtua(byte lower, byte high) {
        return high << 8 & 0xFF00 | lower & 0xFF;
    }

    private int getSeq(byte byte1, byte byte2) {
        return (0xFF & byte2) << 7 | (0xFF & byte1) >> 1;
    }

    private byte readUFrameFunction(byte c1, short length, Message message) {
        byte function = -1;
        if (Constants.containsFunction(c1)) {
            function = length == 6 ? Constants.getTransDownFunction(c1) : c1;
            if (c1 == 67 || c1 == -125) {
                message.setHeartBeat(true);
            }
        }
        return function;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        Channel incoming = ctx.channel();
        channels.add((Object)incoming);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        Channel incoming = ctx.channel();
        channels.remove((Object)incoming);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel incoming = ctx.channel();
        InetSocketAddress insocket = (InetSocketAddress)incoming.remoteAddress();
        String ip = insocket.getAddress().getHostAddress();
        int port = insocket.getPort();
        String ipAndPort = ip + ":" + port;
        this.log.info("\u5728\u7ebf =======>\u8fde\u63a5 Channel:" + incoming.id().toString() + ipAndPort);
        ChannelIpPortCache.putCache((Channel)incoming, (String)ipAndPort);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel incoming = ctx.channel();
        InetSocketAddress insocket = (InetSocketAddress)incoming.remoteAddress();
        String ip = insocket.getAddress().getHostAddress();
        int port = insocket.getPort();
        String ipAndPort = ip + ":" + port;
        this.log.info("\u65ad\u5f00 =======>\u8fde\u63a5 Channel:" + incoming.id().toString() + ipAndPort);
        ChannelIpPortCache.removeCache((Channel)incoming);
        ChannelIdRtuIdCache.removeCache((String)incoming.id().toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel incoming = ctx.channel();
        this.log.debug("\u5f02\u5e38 =======>\u8fde\u63a5 Channel:" + incoming.id().toString());
        cause.printStackTrace();
        ctx.close();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}

