/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.handler.read;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRecognizer
extends ByteToMessageDecoder {
    private final Logger log = LoggerFactory.getLogger(MessageRecognizer.class);

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf in, List<Object> list) throws Exception {
        while (in.readableBytes() >= 6) {
            boolean valid = false;
            int curIndex = in.readerIndex();
            for (int pos = 0; pos < in.readableBytes(); ++pos) {
                in.readerIndex(curIndex + pos);
                byte headSign = in.getByte(curIndex + pos);
                if (headSign != 104) continue;
                valid = true;
                break;
            }
            if (!valid) continue;
            short length = in.getUnsignedByte(in.readerIndex() + 1);
            if (in.readableBytes() >= length + 2) {
                list.add(in.readBytes(length + 2));
                continue;
            }
            this.log.error("\u62a5\u6587\u5934\u5e26\u670968H\uff0c\u4f46\u62a5\u6587\u957f\u5ea6\u5c0f\u4e8e\u62a5\u6587\u643a\u5e26\u6307\u5b9a\u957f\u5ea6");
            break;
        }
    }
}

