/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.handler.writer;

import com.easesource.iot.protoparser.base.cache.ChannelIdRtuIdCache;
import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.iec104.model.Message;
import com.easesource.iot.protoparser.iec104.task.WriterToFile;
import com.easesource.iot.protoparser.iec104.utils.WriterUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class MessageEncoder
extends MessageToByteEncoder<Message> {
    private final Logger logger = LoggerFactory.getLogger(MessageEncoder.class);
    @Autowired
    private WriterToFile writerToFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, Message msg, ByteBuf out) throws Exception {
        int len = 0;
        len = msg.getData() != null ? 6 + msg.getData().length : 6;
        ByteBuf byteBuf = PooledByteBufAllocator.DEFAULT.directBuffer(len);
        try {
            byte[] arr;
            byteBuf.writeByte(104);
            int length = 4;
            if (msg.getData() != null) {
                length += msg.getData().length;
            }
            byteBuf.writeByte(length);
            int c1 = 0;
            int c2 = 0;
            int c3 = 0;
            int c4 = 0;
            switch (msg.getFunction()) {
                case 0: {
                    int sendSeq = msg.getSendSeq();
                    int recvSeq = msg.getRecvSeq();
                    c1 = (byte)((sendSeq <<= 1) & 0xFF);
                    c2 = (byte)(sendSeq >> 8 & 0xFF);
                    c3 = (byte)((recvSeq <<= 1) & 0xFF);
                    c4 = (byte)(recvSeq >> 8 & 0xFF);
                    break;
                }
                case -95: {
                    int recvSeq = msg.getRecvSeq();
                    c1 = 1;
                    c2 = 0;
                    c3 = (byte)((recvSeq <<= 1) & 0xFF);
                    c4 = (byte)(recvSeq >> 8 & 0xFF);
                    break;
                }
                case -94: 
                case 7: {
                    c1 = 7;
                    c2 = 0;
                    c3 = 0;
                    c4 = 0;
                    break;
                }
                case -93: 
                case 11: {
                    c1 = 11;
                    c2 = 0;
                    c3 = 0;
                    c4 = 0;
                    break;
                }
                case -92: 
                case 19: {
                    c1 = 19;
                    c2 = 0;
                    c3 = 0;
                    c4 = 0;
                    break;
                }
                case -91: 
                case 35: {
                    c1 = 35;
                    c2 = 0;
                    c3 = 0;
                    c4 = 0;
                    break;
                }
                case -90: 
                case 67: {
                    c1 = 67;
                    c2 = 0;
                    c3 = 0;
                    c4 = 0;
                    break;
                }
                case -125: 
                case -89: {
                    c1 = -125;
                    c2 = 0;
                    c3 = 0;
                    c4 = 0;
                    break;
                }
            }
            byteBuf.writeByte(c1);
            byteBuf.writeByte(c2);
            byteBuf.writeByte(c3);
            byteBuf.writeByte(c4);
            if (msg.getData() != null && msg.getData().length > 0) {
                byteBuf.writeBytes(msg.getData());
            }
            ByteBuf buf = null;
            try {
                buf = byteBuf.copy();
                int le = buf.readableBytes();
                arr = new byte[le];
                buf.readBytes(arr);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Last Encoder>>>>>>>" + HexDump.hexDump((byte[])arr));
                }
            }
            finally {
                ReferenceCountUtil.release((Object)buf);
            }
            Channel cnl = ctx.channel();
            if (cnl.isWritable()) {
                cnl.writeAndFlush((Object)byteBuf);
            }
            if (msg.getRtuId() != 0) {
                this.writerToFile.handle(WriterUtils.getBytes(msg.isTransDown(), msg.getRtuId(), arr));
            }
            if (ChannelIdRtuIdCache.getKeyCache((String)cnl.id().toString()) != null) {
                this.writerToFile.handle(WriterUtils.getBytes(msg.isTransDown(), ChannelIdRtuIdCache.getKeyCache((String)cnl.id().toString()), arr));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (byteBuf != null) {
                ReferenceCountUtil.release((Object)byteBuf);
            }
        }
    }
}

