/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.model;

import com.easesource.iot.protoparser.base.message.IMessage;
import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.iec104.model.asdu.DataItem;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.Assert;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Message
implements IMessage<Message> {
    private int length;
    private byte function;
    private int sendSeq;
    private int recvSeq;
    private int rtuId;
    private byte[] address;
    private byte[] data;
    private boolean transDown = false;
    private long tranDownCommandId;
    private int transDownCount;
    private int tranDownType;
    private boolean heartBeat;
    private List<DataItem> dataItems = new ArrayList<DataItem>();

    public List<DataItem> getDataItems() {
        return this.dataItems;
    }

    public void setDataItems(List<DataItem> dataItems) {
        this.dataItems = dataItems;
    }

    public void addItem(DataItem item) {
        Assert.notNull((Object)item, (String)"[Assertion failed] - this argument DataItem is required; it must not be null");
        this.dataItems.add(item);
    }

    public static String generatePrimaryKey(int rtuId) {
        return "IEC104M|" + HexDump.toHex((int)rtuId);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public byte getFunction() {
        return this.function;
    }

    public void setFunction(byte function) {
        this.function = function;
    }

    public int getSendSeq() {
        return this.sendSeq;
    }

    public void setSendSeq(int sendSeq) {
        this.sendSeq = sendSeq;
    }

    public int getRecvSeq() {
        return this.recvSeq;
    }

    public void setRecvSeq(int recvSeq) {
        this.recvSeq = recvSeq;
    }

    public void setRtuId(int rtuId) {
        this.rtuId = rtuId;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setTransDown(boolean transDown) {
        this.transDown = transDown;
    }

    public long getTranDownCommandId() {
        return this.tranDownCommandId;
    }

    public void setTranDownCommandId(long tranDownCommandId) {
        this.tranDownCommandId = tranDownCommandId;
    }

    public int getTransDownCount() {
        return this.transDownCount;
    }

    public void setTransDownCount(int transDownCount) {
        this.transDownCount = transDownCount;
    }

    public int getTranDownType() {
        return this.tranDownType;
    }

    public void setTranDownType(int tranDownType) {
        this.tranDownType = tranDownType;
    }

    public boolean isHeartBeat() {
        return this.heartBeat;
    }

    public void setHeartBeat(boolean heartBeat) {
        this.heartBeat = heartBeat;
    }

    public Message createConfirmMessage() {
        Message confirmMessage = new Message();
        switch (this.function) {
            case 5: {
                confirmMessage.setFunction((byte)-94);
                confirmMessage.setSendSeq(0);
                confirmMessage.setRecvSeq(0);
                break;
            }
            case 0: {
                confirmMessage.setRecvSeq(this.getSendSeq() + 1);
                confirmMessage.setFunction((byte)-95);
                break;
            }
            case 1: {
                break;
            }
            case 7: {
                confirmMessage.setFunction((byte)11);
                confirmMessage.setSendSeq(0);
                confirmMessage.setRecvSeq(0);
                break;
            }
            case 11: {
                confirmMessage = null;
                break;
            }
            case 19: {
                confirmMessage.setFunction((byte)35);
                confirmMessage.setSendSeq(0);
                confirmMessage.setRecvSeq(0);
                break;
            }
            case 35: {
                break;
            }
            case 67: {
                confirmMessage.setFunction((byte)-125);
                confirmMessage.setSendSeq(0);
                confirmMessage.setRecvSeq(0);
                break;
            }
            case -125: {
                break;
            }
        }
        confirmMessage.setTransDown(true);
        return confirmMessage;
    }

    public int getRtuId() {
        return this.rtuId;
    }

    public boolean isTransDown() {
        return this.transDown;
    }

    public String getPrimaryKey() {
        return Message.generatePrimaryKey(this.rtuId);
    }

    public String getProtocolName() {
        return "IEC104M";
    }

    public String toString() {
        return "Message{length=" + this.length + ", function=" + this.function + ", sendSeq=" + this.sendSeq + ", recvSeq=" + this.recvSeq + ", rtuId=" + this.rtuId + ", address=" + Arrays.toString(this.address) + ", data=" + Arrays.toString(this.data) + ", transDown=" + this.transDown + ", tranDownCommandId=" + this.tranDownCommandId + ", transDownCount=" + this.transDownCount + ", tranDownType=" + this.tranDownType + ", heartBeat=" + this.heartBeat + ", dataItems=" + this.dataItems + '}';
    }
}

