/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.model;

import com.easesource.iot.protoparser.iec104.model.IItemParser;
import com.easesource.iot.protoparser.iec104.model.asdu.ProtocolDataItemConfig;
import com.easesource.iot.protoparser.iec104.model.format.IDataSets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolDataConfig
implements IDataSets {
    private static final Logger log = LoggerFactory.getLogger(ProtocolDataConfig.class);
    private static ProtocolDataConfig instance;
    private List<ProtocolDataItemConfig> dataItems;
    private Map<String, ProtocolDataItemConfig> dataset;
    private HashMap<String, String> sdataset;
    private HashMap<String, IItemParser> parsers;
    private Map<String, String> codeConvertMap = new HashMap<String, String>();

    public ProtocolDataConfig() {
        instance = this;
    }

    public static ProtocolDataConfig getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolDataItemConfig getDataItemConfig(String code) {
        ProtocolDataItemConfig pdc;
        if (this.dataset == null) {
            ProtocolDataConfig protocolDataConfig = this;
            synchronized (protocolDataConfig) {
                if (this.dataset == null) {
                    this.dataset = new HashMap<String, ProtocolDataItemConfig>();
                    this.sdataset = new HashMap();
                    this.parsers = new HashMap();
                    this.addToItemMap(this.dataItems);
                }
            }
        }
        if ((pdc = this.dataset.get(code)) == null) {
            pdc = this.dataset.get(this.getConvertCode(code));
        }
        return pdc;
    }

    public synchronized void fillMap() {
        instance = this;
        this.dataset = new HashMap<String, ProtocolDataItemConfig>();
        this.sdataset = new HashMap();
        this.parsers = new HashMap();
        this.addToItemMap(this.dataItems);
    }

    private void addToItemMap(List<ProtocolDataItemConfig> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            ProtocolDataItemConfig item = items.get(i);
            this.dataset.put(item.getCode(), item);
            if (item.getParentCode() != null) {
                this.codeConvertMap.put(item.getParentCode(), item.getCode());
            }
            if (item.getBean() != null) {
                this.loadParser(item.getCode(), item.getBean());
            }
            if (item.getItems() != null) {
                List<String> sitems = item.getItems();
                for (String si : sitems) {
                    String keychar = item.getKeychar();
                    if (keychar == null) continue;
                    int index = keychar.indexOf(":");
                    if (index > 0) {
                        String[] keys = keychar.split(":");
                        for (int j = 0; j < keys.length; ++j) {
                            String key = si + "|" + keys[j];
                            this.sdataset.put(key, item.getCode());
                        }
                        continue;
                    }
                    String key = si + "|" + item.getKeychar();
                    this.sdataset.put(key, item.getCode());
                }
            }
            this.addToItemMap(item.getChildItems());
        }
    }

    private void loadParser(String key, String name) {
        if (name != null) {
            try {
                if (!this.parsers.containsKey(name)) {
                    Class<?> clazz = Class.forName(name);
                    this.parsers.put(key, (IItemParser)clazz.newInstance());
                }
            }
            catch (Exception e) {
                log.error("load parser", (Throwable)e);
            }
        }
    }

    public List<ProtocolDataItemConfig> getDataItems() {
        return this.dataItems;
    }

    public void setDataItems(List<ProtocolDataItemConfig> dataItems) {
        this.dataItems = dataItems;
    }

    @Override
    public IItemParser getParser(String key) {
        IItemParser parser = null;
        if (key != null) {
            parser = this.parsers.get(key);
        }
        return parser;
    }

    @Override
    public String getLocal(String key, Object para) {
        return null;
    }

    public String getConvertCode(String code) {
        return this.codeConvertMap.get(code);
    }
}

