/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.model.asdu;

import com.easesource.iot.protoparser.iec104.model.DataValue;
import com.easesource.iot.protoparser.iec104.model.format.DataTimeTag;
import com.easesource.iot.protoparser.iec104.utils.DataSwitch;
import com.easesource.iot.protoparser.iec104.utils.ParseNVA;
import com.easesource.iot.protoparser.iec104.utils.ParserA1;
import com.easesource.iot.protoparser.iec104.utils.ParserA2;
import com.easesource.iot.protoparser.iec104.utils.ParserA3;
import com.easesource.iot.protoparser.iec104.utils.ParserASC;
import com.easesource.iot.protoparser.iec104.utils.ParserBS;
import com.easesource.iot.protoparser.iec104.utils.ParserDATE;
import com.easesource.iot.protoparser.iec104.utils.ParserFTB;
import com.easesource.iot.protoparser.iec104.utils.ParserHEX;
import com.easesource.iot.protoparser.iec104.utils.ParserHTB;
import com.easesource.iot.protoparser.iec104.utils.ParserIP;
import com.easesource.iot.protoparser.iec104.utils.ParserLatitude;
import com.easesource.iot.protoparser.iec104.utils.ParserSIM;
import com.easesource.iot.protoparser.iec104.utils.ParserString;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItemParser {
    private static Logger log = LoggerFactory.getLogger(DataItemParser.class);

    public static DataValue parseValue(String input, String format) {
        DataValue dataValue = new DataValue();
        try {
            String output = "";
            int len = 0;
            try {
                if (format.startsWith("HTB")) {
                    len = Integer.parseInt(format.substring(3));
                    output = ParserHTB.parseValue(input, len * 2);
                } else if (format.startsWith("HEX")) {
                    len = Integer.parseInt(format.substring(3));
                    output = ParserHEX.parseValue(input, len * 2);
                } else if (format.startsWith("STS")) {
                    len = Integer.parseInt(format.substring(3));
                    output = ParserString.parseValue(input, len * 2);
                } else if (format.startsWith("ASC")) {
                    len = Integer.parseInt(format.substring(3));
                    output = ParserASC.parseValue(input, len * 2);
                } else if (format.startsWith("SIM")) {
                    len = Integer.parseInt(format.substring(3));
                    output = ParserSIM.parseValue(input, len * 2);
                } else if (format.startsWith("BS")) {
                    len = Integer.parseInt(format.substring(2));
                    output = ParserBS.parseValue(input, len * 2);
                } else if (format.startsWith("IP")) {
                    len = Integer.parseInt(format.substring(2));
                    output = ParserIP.parseValue(input, len * 2);
                } else if (format.startsWith("N") || format.startsWith("X") || format.startsWith("L")) {
                    len = Integer.parseInt(format.substring(1));
                    output = ParserHTB.parseValue(input, len * 2);
                } else if (format.startsWith("M")) {
                    len = Integer.parseInt(format.substring(1));
                    output = ParserBS.parseValue(input, len * 2);
                } else if (format.equals("A1")) {
                    len = 6;
                    output = ParserA1.parseValue(input, len * 2);
                } else if (format.equals("A2")) {
                    len = 2;
                    output = ParserA2.parseValue(input, len * 2);
                } else if (format.equals("A3")) {
                    len = 4;
                    output = ParserA3.parseValue(input, len * 2);
                } else if (format.equals("A4")) {
                    len = 1;
                    output = ParserFTB.parseValue(input, "CC", len * 2);
                } else if (format.equals("A5")) {
                    len = 2;
                    output = ParserFTB.parseValue(input, "CCC.C", len * 2);
                } else if (format.equals("A6")) {
                    len = 2;
                    output = ParserFTB.parseValue(input, "CC.CC", len * 2);
                } else if (format.equals("A7")) {
                    len = 2;
                    output = ParserFTB.parseValue(input, "000.0", len * 2);
                } else if (format.equals("A8")) {
                    len = 2;
                    output = ParserFTB.parseValue(input, "0000", len * 2);
                } else if (format.equals("A9")) {
                    len = 3;
                    output = ParserFTB.parseValue(input, "CC.CCCC", len * 2);
                } else if (format.equals("A10")) {
                    len = 3;
                    output = ParserFTB.parseValue(input, "000000", len * 2);
                } else if (format.equals("A11")) {
                    len = 4;
                    output = ParserFTB.parseValue(input, "000000.00", len * 2);
                } else if (format.equals("A12")) {
                    len = 6;
                    output = ParserFTB.parseValue(input, "000000000000", len * 2);
                } else if (format.equals("A13")) {
                    len = 4;
                    output = ParserFTB.parseValue(input, "0000.0000", len * 2);
                } else if (format.equals("A14")) {
                    len = 5;
                    output = ParserFTB.parseValue(input, "000000.0000", len * 2);
                } else if (format.equals("A15")) {
                    len = 5;
                    output = ParserDATE.parseValue(input, "yyyy-MM-dd HH:mm", "yyMMddHHmm", len * 2);
                } else if (format.equals("A16")) {
                    len = 4;
                    output = ParserDATE.parseValue(input, "dd HH:mm:ss", "ddHHmmss", len * 2);
                } else if (format.equals("A17")) {
                    len = 4;
                    output = ParserDATE.parseValue(input, "MM-dd HH:mm", "MMddHHmm", len * 2);
                } else if (format.equals("A18")) {
                    len = 3;
                    output = ParserDATE.parseValue(input, "dd HH:mm", "ddHHmm", len * 2);
                } else if (format.equals("A19")) {
                    len = 2;
                    output = ParserDATE.parseValue(input, "HH:mm", "HHmm", len * 2);
                } else if (format.equals("A20")) {
                    len = 3;
                    output = ParserDATE.parseValue(input, "yyyy-MM-dd", "yyMMdd", len * 2);
                } else if (format.equals("A21")) {
                    len = 2;
                    output = ParserDATE.parseValue(input, "yyyy-MM", "yyMM", len * 2);
                } else if (format.equals("A22")) {
                    len = 1;
                    output = ParserFTB.parseValue(input, "0.0", len * 2);
                } else if (format.equals("A23")) {
                    len = 3;
                    output = ParserFTB.parseValue(input, "00.0000", len * 2);
                } else if (format.equals("A24")) {
                    len = 2;
                    output = ParserDATE.parseValue(input, "dd HH", "ddHH", len * 2);
                } else if (format.equals("A25")) {
                    len = 3;
                    output = ParserFTB.parseValue(input, "CCC.CCC", len * 2);
                } else if (format.equals("A26")) {
                    len = 2;
                    output = ParserFTB.parseValue(input, "0.000", len * 2);
                } else if (format.equals("A27")) {
                    len = 4;
                    output = ParserFTB.parseValue(input, "00000000", len * 2);
                } else if (format.equals("A28")) {
                    len = 5;
                    output = ParserLatitude.parseValue(input, len * 2);
                } else if (format.equals("A30")) {
                    len = 4;
                    output = ParserFTB.parseValue(input, "000.00000", len * 2);
                } else if (format.equals("DATE")) {
                    len = 9;
                    output = ParserDATE.parseValue(input, "yyyy-MM-dd HH:mm:ss:SSSS", "yyyyMMddHHmmssSSSS", len * 2);
                } else if (format.equals("A310")) {
                    len = 2;
                    output = ParseNVA.parseValue(input, len * 2);
                } else if (format.equals("A311")) {
                    len = 4;
                    byte[] bs = DataItemParser.hexStringToByte(input.substring(0, 8));
                    float fg = DataItemParser.byte2float(bs);
                    BigDecimal bd = new BigDecimal(fg);
                    output = bd.setScale(7, 6).toString();
                    if (output.equals("0E-7")) {
                        output = "0";
                    }
                } else if (format.equals("A312")) {
                    len = 7;
                    byte[] bs = DataItemParser.hexStringToByte(input.substring(0, 14));
                    String sYear = "" + (bs[6] & 0x7F);
                    sYear = "00".substring(0, 2 - sYear.length()) + sYear;
                    String sMonth = "" + (bs[5] & 0x3F);
                    sMonth = "00".substring(0, 2 - sMonth.length()) + sMonth;
                    String sDate = "" + (bs[4] & 0x1F);
                    sDate = "00".substring(0, 2 - sDate.length()) + sDate;
                    String sHour = "" + (bs[3] & 0x1F);
                    sHour = "00".substring(0, 2 - sHour.length()) + sHour;
                    String sMinute = "" + (bs[2] & 0x3F);
                    sMinute = "00".substring(0, 2 - sMinute.length()) + sMinute;
                    String sMilliseconds = "" + Integer.parseInt(input.substring(2, 4) + input.substring(0, 2), 16);
                    sMilliseconds = "00000".substring(0, 5 - sMilliseconds.length()) + sMilliseconds;
                    sMilliseconds = sMilliseconds.substring(0, 2) + "." + sMilliseconds.substring(2, 5);
                    output = "20" + sYear + "-" + sMonth + "-" + sDate + " " + sHour + ":" + sMinute + ":" + sMilliseconds;
                }
            }
            catch (Exception e) {
                log.error("constructor error:" + e.toString());
            }
            dataValue.setValue(output);
            dataValue.setLen(len * 2);
        }
        catch (Exception e) {
            log.equals("parsevalue error:" + e.toString());
        }
        return dataValue;
    }

    public static String dateStrCheck(String dateStr, String inputStr, String dateFormat) {
        String rt = dateStr;
        if (dateStr.length() == dateFormat.length() && dateFormat.equals("yyyy-MM-dd") && !dateStr.equals(inputStr = "20" + inputStr.substring(0, 2) + "-" + inputStr.substring(2, 4) + "-" + inputStr.substring(4, 6))) {
            log.error("date parse error,inputStr=" + inputStr + ",dateStr=" + dateStr + ",dateFormat=" + dateFormat);
            dateStr = inputStr;
        }
        return rt;
    }

    public static int[] measuredPointParser(String sDA) {
        int iCount = 0;
        int[] measuredListTemp = new int[8];
        try {
            String sDA1 = sDA.substring(0, 2);
            String sDA2 = sDA.substring(2, 4);
            if (sDA.equals("0000")) {
                iCount = 1;
                measuredListTemp[0] = 0;
            } else {
                int iDA2 = Integer.parseInt(sDA2, 16);
                char[] cDA1 = DataSwitch.Fun2HexTo8Bin(sDA1).toCharArray();
                for (int i = 7; i >= 0; --i) {
                    if (cDA1[i] != '1') continue;
                    measuredListTemp[iCount] = (iDA2 - 1) * 8 + 8 - i;
                    ++iCount;
                }
            }
        }
        catch (Exception e) {
            log.error("MeasuredPointParser error:" + e.toString());
        }
        int[] measuredList = new int[iCount];
        for (int i = 0; i < iCount; ++i) {
            measuredList[i] = measuredListTemp[i];
        }
        return measuredList;
    }

    public static String[] dataCodeParser(String sDT, String sAFN) {
        int iCount = 0;
        int[] codeListTemp = new int[8];
        try {
            String sDT1 = sDT.substring(0, 2);
            String sDT2 = sDT.substring(2, 4);
            int iDT2 = Integer.parseInt(sDT2, 16);
            char[] cDT1 = DataSwitch.Fun2HexTo8Bin(sDT1).toCharArray();
            for (int i = 7; i >= 0; --i) {
                if (cDT1[i] != '1') continue;
                codeListTemp[iCount] = iDT2 * 8 + 8 - i;
                ++iCount;
            }
        }
        catch (Exception e) {
            log.error("dataCodeParser error:" + e.toString());
        }
        String[] codeList = new String[iCount];
        for (int i = 0; i < iCount; ++i) {
            codeList[i] = sAFN + "F" + DataSwitch.StrStuff("0", 3, "" + codeListTemp[i], "left");
        }
        return codeList;
    }

    public static DataTimeTag getTaskDateTimeInfo(String sDateTimeLabel, int DateType, String rtuAddr) {
        DataTimeTag dataTimeTag = new DataTimeTag();
        try {
            String sDateTime = "";
            String sNowDateTime = "";
            int iDataDensity = 0;
            int iDataCount = 0;
            if (DateType == 1) {
                sDateTime = "" + (Integer.parseInt(sDateTimeLabel.substring(0, 1)) & 3) + sDateTimeLabel.substring(1, 2);
                iDataDensity = Integer.parseInt(sDateTimeLabel.substring(2, 4), 16);
                Calendar cLogTime = Calendar.getInstance();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
                sNowDateTime = formatter.format(cLogTime.getTime());
                if (Integer.parseInt(sDateTime) > Integer.parseInt(sNowDateTime.substring(8, 10))) {
                    sNowDateTime = DataSwitch.IncreaseDateTime(sNowDateTime, -1, 4);
                    sNowDateTime = sNowDateTime.substring(0, 4) + sNowDateTime.substring(5, 7) + sNowDateTime.substring(8, 10) + sNowDateTime.substring(11, 13) + sNowDateTime.substring(14, 16);
                }
            } else if (DateType == 2) {
                sDateTime = "20" + DataSwitch.ReverseStringByByte(sDateTimeLabel.substring(0, 10));
                iDataDensity = Integer.parseInt(sDateTimeLabel.substring(10, 12), 16);
                iDataCount = Integer.parseInt(sDateTimeLabel.substring(12, 14), 16);
            } else if (DateType == 3) {
                sDateTime = DataItemParser.parseValue(sDateTimeLabel.substring(0, 6), "A20").getValue();
            } else if (DateType == 4) {
                sDateTime = DataItemParser.parseValue(sDateTimeLabel.substring(0, 4), "A21").getValue();
            }
            switch (iDataDensity) {
                case 1: {
                    iDataDensity = 15;
                    if (DateType != 1) break;
                    sDateTime = sNowDateTime.substring(0, 8) + sDateTime + "15";
                    iDataCount = 4;
                    break;
                }
                case 2: {
                    iDataDensity = 30;
                    if (DateType != 1) break;
                    sDateTime = sNowDateTime.substring(0, 8) + sDateTime + "30";
                    iDataCount = 2;
                    break;
                }
                case 3: {
                    iDataDensity = 60;
                    if (DateType != 1) break;
                    sDateTime = sNowDateTime.substring(0, 8) + sDateTime + "00";
                    iDataCount = 1;
                    break;
                }
                case 254: {
                    iDataDensity = 5;
                    if (DateType != 1) break;
                    sDateTime = sNowDateTime.substring(0, 8) + sDateTime + "05";
                    iDataCount = 12;
                    break;
                }
                case 255: {
                    iDataDensity = 1;
                    if (DateType != 1) break;
                    sDateTime = sNowDateTime.substring(0, 8) + sDateTime + "01";
                    iDataCount = 60;
                    break;
                }
                default: {
                    iDataDensity = 0;
                    iDataCount = 1;
                }
            }
            dataTimeTag.setDataTime(sDateTime);
            dataTimeTag.setDataDensity(iDataDensity);
            dataTimeTag.setDataCount(iDataCount);
        }
        catch (Exception e) {
            log.error("getTaskDateTimeInfo error\uff1a" + e.toString());
        }
        return dataTimeTag;
    }

    public static DataValue parser(String input, String format, boolean recurrentTag) {
        DataValue dataItem;
        block15: {
            dataItem = new DataValue();
            try {
                String[] formatItems = format.split("#");
                String value = "";
                int len = 0;
                DataValue dataItemTemp = new DataValue();
                if (formatItems.length <= 0) break block15;
                for (int i = 0; i < formatItems.length; ++i) {
                    if (formatItems[i].startsWith("N") || formatItems[i].startsWith("M")) {
                        DataValue nValue = DataItemParser.parseValue(input, formatItems[i]);
                        input = input.substring(nValue.getLen());
                        format = format.substring(format.indexOf("#") + 1);
                        value = value + nValue.getValue() + "#";
                        len += nValue.getLen();
                        if (formatItems[i].startsWith("M")) {
                            nValue.setValue("" + ParserBS.getBSCount(nValue.getValue()));
                        }
                        for (int j = 0; j < Integer.parseInt(nValue.getValue()); ++j) {
                            if (format.indexOf("N") >= 0 || format.indexOf("M") >= 0) {
                                dataItemTemp = DataItemParser.parser(input, format, true);
                                input = input.substring(dataItemTemp.getLen());
                                value = value + dataItemTemp.getValue() + ";";
                            } else {
                                dataItemTemp = DataItemParser.parser(input, format, false);
                                input = input.substring(dataItemTemp.getLen());
                                value = !recurrentTag ? value + dataItemTemp.getValue() + ";" : value + dataItemTemp.getValue() + ",";
                            }
                            len += dataItemTemp.getLen();
                        }
                        if (!value.endsWith(",") && !value.endsWith(";")) break;
                        value = value.substring(0, value.length() - 1);
                        break;
                    }
                    if (formatItems[i].startsWith("X")) {
                        DataValue nValue = new DataValue();
                        while (format.length() > 0) {
                            if (format.indexOf("#") > 0 && format.substring(0, format.indexOf("#")).startsWith("X")) {
                                nValue = DataItemParser.parseValue(input, format.substring(0, format.indexOf("#")));
                                format = format.substring(format.indexOf("#") + 1);
                                input = input.substring(nValue.getLen());
                                value = value + nValue.getValue() + "#";
                                len += nValue.getLen();
                                for (int j = 0; j < Integer.parseInt(nValue.getValue()); ++j) {
                                    dataItemTemp = DataItemParser.parser(input, format.substring(0, format.indexOf("#")), false);
                                    input = input.substring(dataItemTemp.getLen());
                                    value = value + dataItemTemp.getValue() + ";";
                                    len += dataItemTemp.getLen();
                                }
                                if (value.endsWith(";")) {
                                    value = value.substring(0, value.length() - 1) + "#";
                                }
                                format = format.substring(format.indexOf("#") + 1);
                                continue;
                            }
                            dataItemTemp = DataItemParser.parseValue(input, format);
                            input = input.substring(dataItemTemp.getLen());
                            format = "";
                            value = value + dataItemTemp.getValue() + "#";
                            len += dataItemTemp.getLen();
                        }
                        break;
                    }
                    if (formatItems[i].startsWith("L")) {
                        DataValue nValue = new DataValue();
                        nValue = DataItemParser.parseValue(input, formatItems[i]);
                        input = input.substring(nValue.getLen());
                        format = format.substring(format.indexOf("#") + 1);
                        value = value + nValue.getValue() + "#";
                        len += nValue.getLen();
                        dataItemTemp = DataItemParser.parser(input, "A15", false);
                        input = input.substring(dataItemTemp.getLen());
                        value = value + dataItemTemp.getValue() + "#";
                        len += dataItemTemp.getLen();
                        dataItemTemp = DataItemParser.parser(input, "A15", false);
                        input = input.substring(dataItemTemp.getLen());
                        value = value + dataItemTemp.getValue() + "#";
                        len += dataItemTemp.getLen();
                        int iCount = Integer.parseInt(nValue.getValue());
                        int iLen = 0;
                        iLen = iCount % 2 == 0 ? iCount / 2 : iCount / 2 + 1;
                        dataItemTemp = DataItemParser.parser(input, "HEX" + iLen, false);
                        input = input.substring(dataItemTemp.getLen());
                        value = value + dataItemTemp.getValue();
                        len += dataItemTemp.getLen();
                        break;
                    }
                    dataItemTemp = DataItemParser.parseValue(input, formatItems[i]);
                    input = input.substring(dataItemTemp.getLen());
                    format = format.substring(format.indexOf("#") + 1);
                    value = value + dataItemTemp.getValue() + "#";
                    len += dataItemTemp.getLen();
                }
                if (value.endsWith("#") || value.endsWith(",") || value.endsWith(";")) {
                    value = value.substring(0, value.length() - 1);
                }
                dataItem.setValue(value);
                dataItem.setLen(len);
            }
            catch (Exception e) {
                log.error("coder error:" + e.toString());
            }
        }
        return dataItem;
    }

    public static boolean isValidTime(String input, String inputFormat) {
        boolean rt = false;
        if (input.length() == inputFormat.length()) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(inputFormat);
                Date dt = df.parse(input);
                Calendar ct = Calendar.getInstance();
                ct.setTime(dt);
                if (ct.getTimeInMillis() > System.currentTimeMillis()) {
                    rt = false;
                    return false;
                }
                df = new SimpleDateFormat("yyyy-MM-dd");
                String output = df.format(dt);
                if (input.equals(output)) {
                    rt = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rt;
    }

    public static byte[] hexStringToByte(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(DataItemParser.toByte(achar[pos]) << 4 | DataItemParser.toByte(achar[pos + 1]));
        }
        return result;
    }

    private static int toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }

    public static float byte2float(byte[] b) {
        int l = b[0];
        l &= 0xFF;
        l = (int)((long)l | (long)b[1] << 8);
        l &= 0xFFFF;
        l = (int)((long)l | (long)b[2] << 16);
        l &= 0xFFFFFF;
        l = (int)((long)l | (long)b[3] << 24);
        return Float.intBitsToFloat(l);
    }
}

