/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.model.asdu;

import com.easesource.iot.protoparser.iec104.model.asdu.IDataItem;
import com.easesource.iot.protoparser.iec104.utils.ParseTool;
import java.util.List;

public class ProtocolDataItemConfig
implements IDataItem {
    private String code;
    private String parentCode;
    private int length;
    private String type;
    private String format;
    private int parserno = 0;
    private int fraction = 0;
    private String description;
    private String keychar;
    private String bean;
    private String property;
    private List<ProtocolDataItemConfig> childItems;
    private int datakey;
    private List<String> items;
    private int dkey;

    public int getDataKey() {
        return this.datakey;
    }

    public int getDatakey() {
        return this.datakey;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
        this.datakey = ParseTool.HexToDecimal(code);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getLength() {
        if (this.length == 0 && this.childItems != null) {
            for (int i = 0; i < this.childItems.size(); ++i) {
                this.length += this.childItems.get(i).getLength();
            }
        }
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        try {
            if (type != null && type.length() > 3) {
                this.parserno = Integer.parseInt(type.substring(0, 2));
                this.fraction = Integer.parseInt(type.substring(2, 4));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getBean() {
        return this.bean;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public List<ProtocolDataItemConfig> getChildItems() {
        return this.childItems;
    }

    public void setChildItems(List<ProtocolDataItemConfig> childItems) {
        this.childItems = childItems;
        this.length = 0;
    }

    public int getFraction() {
        return this.fraction;
    }

    public int getParserno() {
        return this.parserno;
    }

    @Override
    public String getSdRobot() {
        return null;
    }

    @Override
    public List<String> getStandardDatas() {
        return this.items;
    }

    @Override
    public boolean isMe(String dataid) {
        boolean rt = false;
        if (this.items != null) {
            for (String dk : this.items) {
                if (!dk.equalsIgnoreCase(dataid)) continue;
                rt = true;
                break;
            }
        }
        return rt;
    }

    public List<String> getItems() {
        return this.items;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public String getKeychar() {
        return this.keychar;
    }

    public void setKeychar(String keychar) {
        this.keychar = keychar;
    }

    public int getDkey() {
        return this.dkey;
    }

    public void setDkey(int dkey) {
        this.dkey = dkey;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getParentCode() {
        return this.parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }
}

