/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.utils;

import com.easesource.iot.protoparser.base.utils.HexDump;
import com.easesource.iot.protoparser.iec104.exception.MessageDecodeException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DataSwitch {
    private static final Logger log = LoggerFactory.getLogger(DataSwitch.class);

    public static void main(String[] args) throws Exception {
        System.out.println(DataSwitch.Fun2HexTo8Bin("FF"));
        System.out.println(DataSwitch.toBitString((byte)15));
        System.out.println(DataSwitch.Fun8BinTo2Hex("00001111"));
        System.out.println(HexDump.toHex((byte)DataSwitch.bitStrToByte("00001111")));
        System.out.println(DataSwitch.isBCDString("0123456789"));
        System.out.println(DataSwitch.IntToHex("32767", 6));
        System.out.println(DataSwitch.toHexStr(65536));
    }

    public static String toBitString(byte b) {
        StringBuffer buf = new StringBuffer();
        buf.append(b >> 7 & 1);
        buf.append(b >> 6 & 1);
        buf.append(b >> 5 & 1);
        buf.append(b >> 4 & 1);
        buf.append(b >> 3 & 1);
        buf.append(b >> 2 & 1);
        buf.append(b >> 1 & 1);
        buf.append(b >> 0 & 1);
        return buf.toString();
    }

    public static byte bitStrToByte(String bitStr) {
        if (bitStr == null || bitStr.length() != 8) {
            throw new IllegalArgumentException("\u4e8c\u8fdb\u5236\u5b57\u7b26\u4e32\u957f\u5ea6\u4e0d\u7b49\u4e8e8");
        }
        return (byte)Integer.parseInt(bitStr, 2);
    }

    public static String toHexStr(int i) {
        return HexDump.toHex((int)i);
    }

    public static String IntToHex(String sInt, int len) {
        String sDataContent = "";
        try {
            sInt = Integer.toString(Integer.parseInt(sInt), 16).toUpperCase();
            sDataContent = DataSwitch.StrStuff("0", len, sInt, "left");
        }
        catch (Exception e) {
            throw new MessageDecodeException(e);
        }
        return sDataContent;
    }

    public static String ReverseStringByByte(String str) {
        String sOutput;
        block4: {
            sOutput = "";
            try {
                if (str.length() % 2 == 0) {
                    for (int i = 0; i < str.length() / 2; ++i) {
                        sOutput = sOutput + str.substring(str.length() - (i + 1) * 2, str.length() - i * 2);
                    }
                    break block4;
                }
                throw new MessageDecodeException("ReverseStringByByte() error,input:" + str);
            }
            catch (Exception e) {
                throw new MessageDecodeException(e);
            }
        }
        return sOutput;
    }

    public static boolean isBCDString(String str) {
        boolean tag = true;
        if (StringUtils.hasText((String)str)) {
            char[] chars;
            for (char chr : chars = str.toCharArray()) {
                if (chr >= '0' && chr <= '9') continue;
                tag = false;
                break;
            }
        }
        return tag;
    }

    public static String StrStuff(String str, int iLen, String sInput, String sSign) {
        String sOutput = "";
        try {
            int iLenStr = sInput.length();
            if (iLen > iLenStr) {
                for (int i = 0; i < iLen - iLenStr; ++i) {
                    sInput = sSign.equals("left") ? str + sInput : sInput + str;
                }
            } else if (iLen < iLenStr) {
                sInput = sSign.equals("left") ? sInput.substring(iLenStr - iLen, iLenStr) : sInput.substring(0, iLen);
            }
            sOutput = sInput;
        }
        catch (Exception e) {
            throw new MessageDecodeException(e);
        }
        return sOutput;
    }

    public static String Fun8BinTo2Hex(String sBit8) {
        return HexDump.toHex((byte)DataSwitch.bitStrToByte(sBit8));
    }

    public static String Fun2HexTo8Bin(String hex) {
        byte b = (byte)Short.parseShort(hex, 16);
        return DataSwitch.toBitString(b);
    }

    public static String[] dataCodeParser(byte dt1, byte dt2, byte afn) {
        int iCount = 0;
        int[] codeListTemp = new int[8];
        char[] cDT1 = DataSwitch.toBitString(dt1).toCharArray();
        for (int i = 7; i >= 0; --i) {
            if (cDT1[i] != '1') continue;
            codeListTemp[iCount] = dt2 * 8 + 8 - i;
            ++iCount;
        }
        String[] codeList = new String[iCount];
        for (int i = 0; i < iCount; ++i) {
            codeList[i] = HexDump.toHex((byte)afn) + "F" + DataSwitch.StrStuff("0", 3, "" + codeListTemp[i], "left");
        }
        return codeList;
    }

    public static int[] measuredPointParser(byte dt1, byte dt2) {
        int i;
        int iCount = 0;
        int[] measuredListTemp = new int[8];
        if (dt1 == 0 && dt2 == 0) {
            iCount = 1;
            measuredListTemp[0] = 0;
        } else {
            char[] cDA1 = DataSwitch.toBitString(dt1).toCharArray();
            for (i = 7; i >= 0; --i) {
                if (cDA1[i] != '1') continue;
                measuredListTemp[iCount] = (dt2 - 1) * 8 + 8 - i;
                ++iCount;
            }
        }
        int[] measuredList = new int[iCount];
        for (i = 0; i < iCount; ++i) {
            measuredList[i] = measuredListTemp[i];
        }
        return measuredList;
    }

    public static String IncreaseDateTime(String sDateTime, int iIncreaseNo, int iIncreaseType) {
        String sResult = "";
        Calendar dateTime = Calendar.getInstance();
        dateTime.set(Integer.parseInt(sDateTime.substring(0, 4)), Integer.parseInt(sDateTime.substring(4, 6)) - 1, Integer.parseInt(sDateTime.substring(6, 8)), Integer.parseInt(sDateTime.substring(8, 10)), Integer.parseInt(sDateTime.substring(10, 12)), 0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            switch (iIncreaseType) {
                case 2: {
                    dateTime.add(12, iIncreaseNo);
                    break;
                }
                case 3: {
                    dateTime.add(10, iIncreaseNo);
                    break;
                }
                case 4: {
                    dateTime.add(5, iIncreaseNo);
                    break;
                }
                case 5: {
                    dateTime.add(2, iIncreaseNo);
                }
            }
            sResult = formatter.format(dateTime.getTime());
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u533a\u89e3\u6790IncreaseDateTime\u51fa\u9519:" + e.toString());
        }
        return sResult;
    }
}

