/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.utils;

import com.easesource.iot.protoparser.iec104.exception.MessageDecodeException;
import com.easesource.iot.protoparser.iec104.utils.DataSwitch;

public class ParseNVA {
    public static String parseValue(String data, int len) {
        String rt = "";
        try {
            data = DataSwitch.ReverseStringByByte(data.substring(0, len));
            if (!DataSwitch.isBCDString(data)) {
                return rt;
            }
            String sTemp = DataSwitch.Fun2HexTo8Bin(data);
            String sTag = sTemp.substring(0, 1);
            String ft = "%.5f";
            if (sTag.equals("0")) {
                Double d = Double.valueOf(data);
                rt = String.format(ft, d / 32767.0);
            } else {
                Double d = Double.valueOf(data) - 32768.0;
                rt = String.format(ft, d / -32768.0);
            }
        }
        catch (Exception e) {
            throw new MessageDecodeException(e);
        }
        return rt;
    }

    public static void main(String[] args) {
        System.out.println(ParseNVA.parseValue("1234", 4));
    }
}

