/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.utils;

import com.easesource.iot.protoparser.iec104.exception.MessageDecodeException;
import com.easesource.iot.protoparser.iec104.exception.MessageEncodeException;
import com.easesource.iot.protoparser.iec104.utils.DataSwitch;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ParserA1 {
    public static String parseValue(String data, int len) {
        String rt = "";
        try {
            data = DataSwitch.ReverseStringByByte(data.substring(0, len));
            if (data.indexOf("EE") >= 0 || data.indexOf("FF") >= 0) {
                return rt;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss");
            int month = Integer.parseInt(data.substring(2, 3), 16) & 1;
            data = data.substring(0, 2) + month + data.substring(3);
            Date dt = df.parse(data);
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            rt = df.format(dt);
        }
        catch (Exception e) {
            throw new MessageDecodeException(e);
        }
        return rt;
    }

    public static String constructor(String data, int len) {
        String rt = "";
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date dt = df.parse(data);
            df = new SimpleDateFormat("yyMMddHHmmss");
            rt = df.format(dt);
            Calendar date = Calendar.getInstance();
            date.setTime(dt);
            int week = date.get(7);
            week = week == 1 ? 7 : --week;
            int month = Integer.parseInt(rt.substring(2, 3));
            month = week * 2 + month;
            rt = rt.substring(0, 2) + Integer.toString(month, 16) + rt.substring(3);
            rt = DataSwitch.ReverseStringByByte(rt);
        }
        catch (Exception e) {
            throw new MessageEncodeException(e);
        }
        return rt;
    }
}

