/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.iec104.writer;

import com.easesource.iot.protoparser.base.cache.DcuIdChannelCache;
import com.easesource.iot.protoparser.base.thread.handler.IThreadEventHandler;
import com.easesource.iot.protoparser.base.thread.handler.ThreadPool;
import com.easesource.iot.protoparser.base.utils.BytesUtil;
import com.easesource.iot.protoparser.iec104.codec.encoder.DataItemEncoder;
import com.easesource.iot.protoparser.iec104.model.DataCommand;
import com.easesource.iot.protoparser.iec104.model.Message;
import com.easesource.iot.protoparser.iec104.model.asdu.DataItem;
import com.easesource.iot.protoparser.iec104.writer.IPostmanHandler;
import io.netty.channel.Channel;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PostmanHandler
extends ThreadPool<Message>
implements IThreadEventHandler<Message>,
IPostmanHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public PostmanHandler() {
        this.threadEventHandler = this;
    }

    @PostConstruct
    public boolean start() {
        super.init();
        return super.start();
    }

    public void handleEvent(Message msg) throws Exception {
        if (msg != null) {
            Channel channel;
            DataCommand cmd = null;
            List<DataItem> list = null;
            if (msg.getDataItems() != null) {
                cmd = new DataCommand(BytesUtil.StringTobyte((String)msg.getDataItems().get(0).getCode()), (short)msg.getSendSeq(), msg.getRtuId());
                cmd.setCot(msg.getDataItems().get(0).getCot());
                list = msg.getDataItems();
            }
            int cruId = msg.getRtuId();
            if (cmd != null && list != null) {
                DataItemEncoder encoder = new DataItemEncoder();
                msg = (Message)encoder.encode(list, cmd, msg);
            }
            if ((channel = DcuIdChannelCache.getKeyCache((Integer)cruId)) != null && channel.isWritable()) {
                channel.writeAndFlush((Object)msg);
            }
        }
    }

    public boolean isNeedNewThread(Message o) {
        return true;
    }

    @Override
    public void handler(Message msg) {
        this.offer(msg);
    }
}

