package com.gaea.iesms.bm.alarm.config;


import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;

import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Value;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;



import static com.gaea.iesms.bm.alarm.model.MqConstants.*;


@Configuration
public class RabbitMqConfigConguration {

    @Value("${spring.rabbitmq.host:192.168.1.214}")
    private String addresses;

    @Value("${spring.rabbitmq.port:5672}")
    private int port;

    @Value("${spring.rabbitmq.username:admin}")
    private String username;

    @Value("${spring.rabbitmq.password:admin2k21}")
    private String password;

    @Value("${spring.rabbitmq.virtual-host:/}")
    private String virtualHost;
    /**
     * 连接工厂
     *
     * @return org.springframework.amqp.rabbit.connection.ConnectionFactory
     */
    @Bean
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(addresses, port);
        connectionFactory.setUsername(username);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost(virtualHost);
        return connectionFactory;
    }


    /**
     * Queue类的参数
     * 1.队列名字
     * 2.durable="true" 是否持久化rabbitmq重启的时候不需要创建新的队列
     * 3.auto-delete 表示消息队列没有在使用时将被自动删除 默认时false
     * 4.exclusive  表示该消息队列是否只在当前connection生效，默认是false
     */
    @Bean
    public Queue dirctQueue() {
        return new Queue(ALARM_QUEUE, true, false, false);
    }
    /**
     * 1.交换机名字
     * 2.durable="true" 是否持久化rabbitmq重启的时候不需要创建新的交换机
     * 3.autoDelete 当所有消费客户端连接断开后，是否自动删除队列
     */
    @Bean
    public DirectExchange directExchange() {
        return new DirectExchange(ALARM_EXCHANGE, true, false);
    }
    /**
     * 将direct队列和交换机进行绑定
     */
    @Bean
    public Binding bingdingDirect() {
        return BindingBuilder.bind(dirctQueue()).to(directExchange()).with(ALARM_ROUTING_KEY);
    }

    /**
     * 定义消息转换实例 转化成JSON 传输 传输实体就可以不用实现序列化
     *
     * @return
     */
    @Bean
    public MessageConverter integrationEventMessageConverter() {
        return new Jackson2JsonMessageConverter();
    }


}
