package com.gaea.iesms.bm.alarm.model.response.vo;

import com.gaea.iesms.core.model.jsonobject.alarm.SoeSortBizpropsJsonObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Author wangxiangzhong
 * @Description 告警分类返回参数
 * @Date 2023/03/24/10:36
 */
@ApiModel(value = "告警分类返回参数")
@Data
public class SoeSortVo {

    @ApiModelProperty(value = "事件分类ID")
    protected Long id;

    @ApiModelProperty(value = "事件分类编号")
    private String soeSortNo;

    @ApiModelProperty(value = "事件分类名称")
    private String soeSortName;

    @ApiModelProperty(value = "事件分类别名")
    private String soeSortAlias;

    @ApiModelProperty(value = "事件分类说明")
    private String soeSortDesc;

    @ApiModelProperty(value = "事件分类诊断算法说明")
    private String soeSortDaDesc;

    @ApiModelProperty(value = "事件分类业务属性集")
    private SoeSortBizpropsJsonObject soeSortBizprops;

    @ApiModelProperty(value = "事件分类大类，编码SOE_SORT_CLASS_CODE")
    private String soeSortClass;

    @ApiModelProperty(value = "事件对象类型：1 - 采集终端设备；2 - 采集器设备；3 - 量测表计设备；10 - 用能点；20 - 用能资源")
    private Integer soeObjectType;
}
