package com.gaea.iesms.bm.alarm.service.impl;

import com.gaea.iesms.bm.alarm.mapper.SoeRecordMapper;
import com.gaea.iesms.bm.alarm.model.SoeRecordSaveDto;
import com.gaea.iesms.bm.alarm.service.CeSoeSortService;
import com.gaea.iesms.bm.alarm.service.CombinerBoxAlarmService;
import com.gaea.iesms.bm.alarm.service.SoeRecordService;
import com.gaea.iesms.core.feign.dto.MeasDataCumFreezeCurveValueDTO;
import com.gaea.iesms.core.feign.request.alarm.CombinerBoxBranchCircuitAlarmRequest;
import com.gaea.iesms.core.model.entity.alarm.SoeRecord;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeGenValueJsonObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author wangxiangzhong
 * @Description 汇流箱告警
 * @Date 2023/04/28/14:47
 */
@Service
public class CombinerBoxAlarmServiceImpl implements CombinerBoxAlarmService {

    @Resource
    private SoeRecordMapper soeRecordMapper;

    @Resource
    private CeSoeSortService ceSoeSortService;

    @Resource
    private SoeRecordService soeRecordService;

//    @Resource
//    private DataCenterCommonService dataCenterCommonService;


//    @Override
//    public boolean combinerBoxBranchCircuitAlarm(List<CombinerBoxBranchCircuitAlarmRequest> combinerBoxBranchCircuitAlarmList) {
//        String soeSortNo = SoeSortEnum.SOE_METER_GATHER_FAILURE.getValue();
//        for (CombinerBoxBranchCircuitAlarmRequest combinerBoxBranchCircuit : combinerBoxBranchCircuitAlarmList) {
//            //map.put("soeObjectId", list.getId());
////                map.put("soeSortNo", "SOE_DEV_PV_CONFLUENCE_BOX_COMM_FAILURE");
//            //map.put("soeSortNo", "SOE_METER_GATHER_FAILURE");
//            //TODO 获取告警表中未复归的数量（查看该汇流箱是否有通讯故障告警）
////                int count = bmIesmsSoeSortMapper.getRecordNotRecoveryCount(map);
//            int count = soeRecordMapper.getMeterSoeCount(String.valueOf(combinerBoxBranchCircuit.getDeviceId()),soeSortNo);
//            if (count < 0) {
//                if (StrUtil.isNotBlank(combinerBoxBranchCircuit.getMeasPointIdList()) && combinerBoxBranchCircuit.getMeasPointIdList().length() > 2) {
//                    for (int j = 0; j < 17; j++) {
//                        String codeName = "gen_watt_ir" + j;
//                        String alarmSortNo = "SOE_DEV_PV_CONFLUENCE_BOX_CUTOFF_ALARM_R" + String.format("%02d", j);
//                        List<Long> measPonitId = this.fromArray(combinerBoxBranchCircuit.getMeasPointIdList());
//                        long endTime = System.currentTimeMillis();
//                        long startTime = endTime - (60 * 60 * 1000);
//
//                        //TODO 获取汇流箱最近一小时内的电流
//                        MeasDataCumFreezeCurveGetRangeRequest measDataCumFreezeCurveGetRangeRequest = new MeasDataCumFreezeCurveGetRangeRequest();
//                        measDataCumFreezeCurveGetRangeRequest.setMeasPointId(measPonitId.get(0));
//                        measDataCumFreezeCurveGetRangeRequest.setMeasItemCodeSet(Sets.newHashSet(codeName));
//                        measDataCumFreezeCurveGetRangeRequest.setGmtMeasFreezeStart(startTime);
//                        measDataCumFreezeCurveGetRangeRequest.setGmtMeasFreezeEnd(endTime);
//                        R<MeasDataCumFreezeCurveGetRangeResponse> rangeMeasDataCumFreezeCurve =null;// dataCenterCommonService.getRangeMeasDataCumFreezeCurve(measDataCumFreezeCurveGetRangeRequest);
//
//                        MeasDataCumFreezeCurveGetRangeResponse measDataCumFreezeCurveData = rangeMeasDataCumFreezeCurve.getData();
//                        Map<String, List<MeasDataCumFreezeCurveValue>> measDataListMap = measDataCumFreezeCurveData.getMeasDataListMap();
//                        List<MeasDataCumFreezeCurveValue> curevList = measDataListMap.get(codeName);
//                        //TODO 如果连续三个点的 数据为0 那么生成一条告警
//                        if (curevList != null && curevList.size() > 3) {
//                            if (curevList.get(curevList.size() - 1).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
//                                    && curevList.get(curevList.size() - 2).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
//                                    && curevList.get(curevList.size() - 3).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
//                            ) {
//                                //TODO 查看该汇流箱是否断路告警 如果有不管 没有新增
//                                count = soeRecordMapper.getRecordNotRecoveryCount(combinerBoxBranchCircuit.getSoeSortNo(), combinerBoxBranchCircuit.getDeviceId());
//                                if (count <= 0) {
//                                    SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
//                                    soeRecordSaveDto.setSoeObjectId(combinerBoxBranchCircuit.getDeviceId());
//                                    soeRecordSaveDto.setSoeSortNo(alarmSortNo);
//                                    soeRecordSaveDto.setOrgNo(combinerBoxBranchCircuit.getOrgNo());
//                                    soeRecordSaveDto.setSoeObjectName(combinerBoxBranchCircuit.getCeResName());
//                                    SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
//                                    soeGenValueJsonObject.setCeCustId(combinerBoxBranchCircuit.getCeCustId());
//                                    soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
//                                    soeRecordService.insertSoeRecordAndPushRedis(soeRecordSaveDto);
//                                }
//                            } else {
//                                //map.put("soeSortNo", alarmName);
//                                //TODO 查看该汇流箱是否断路告警  如果大于0 说明有 那么复归他
//                                count = soeRecordMapper.getRecordNotRecoveryCount(combinerBoxBranchCircuit.getSoeSortNo(), combinerBoxBranchCircuit.getDeviceId());
//                                if (count > 0) {
//                                    SoeRecord recordDo = new SoeRecord();
//                                    recordDo.setOrgNo(combinerBoxBranchCircuit.getOrgNo());
//                                    recordDo.setSoeObjectType(1);
//                                    recordDo.setSoeSortNo(alarmSortNo);
//                                    recordDo.setSoeObjectId(combinerBoxBranchCircuit.getDeviceId());
//                                    recordDo.setGmtModified(System.currentTimeMillis());
//                                    SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
//                                    soeGenValueJsonObject.setCeCustId(combinerBoxBranchCircuit.getCeCustId());
//                                    recordDo.setSoeGenValue(soeGenValueJsonObject);
//                                    recordDo.setIsRecovery(true);
//                                    recordDo.setModifier("sysadmin");
//                                    recordDo.setSoeRecTime(new Date());
//                                    soeRecordService.updateSoeRecord(recordDo);
//                                }
//
//                            }
//                        }
//                    }
//                }
//            }
//
//        }
//        return true;
//    }
    public static List<Long> fromArray(String arrayStr) {
        if (StringUtils.isBlank(arrayStr)) {
            return new ArrayList();
        } else {
            String string = arrayStr.replace("[", "").replace("]", "").replace(" ", "");
            String[] arr = string.split(",");
            List<String> list = Arrays.asList(arr);
            return (List) list.stream().distinct().filter((str) -> {
                return !Objects.equals(str, "null");
            }).filter(StringUtils::isNotBlank).filter((str) -> {
                return !Objects.equals(str, "0");
            }).map(Long::valueOf).collect(Collectors.toList());
        }
    }

    @Override
    public boolean combinerBoxBranchCircuitAlarm(List<CombinerBoxBranchCircuitAlarmRequest> combinerBoxBranchCircuitAlarmList) {
        //String soeSortNo = SoeSortEnum.SOE_METER_GATHER_FAILURE.getValue();
        for (CombinerBoxBranchCircuitAlarmRequest combinerBoxBranchCircuit : combinerBoxBranchCircuitAlarmList) {
            int count = 0;
            //bmIesmsSoeSortMapper.getMeterSoeCount(map);
                List<MeasDataCumFreezeCurveValueDTO> curveValueList = combinerBoxBranchCircuit.getCurveValueList();
                if (curveValueList != null && curveValueList.size() > 3) {
                    if (curveValueList.get(curveValueList.size() - 1).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
                            && curveValueList.get(curveValueList.size() - 2).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
                            && curveValueList.get(curveValueList.size() - 3).getMeasDataValue().compareTo(BigDecimal.ZERO) == 0
                    ) {
                        //map.put("soeSortNo", alarmName);
                        //TODO 查看该汇流箱是否断路告警 如果有不管 没有新增
                        count = soeRecordMapper.getRecordNotRecoveryCount(combinerBoxBranchCircuit.getSoeSortNo(),combinerBoxBranchCircuit.getDeviceId());
                        if (count <= 0) {
                            SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                            soeRecordSaveDto.setSoeObjectId(combinerBoxBranchCircuit.getDeviceId());
                            soeRecordSaveDto.setSoeSortNo(combinerBoxBranchCircuit.getSoeSortNo());
                            soeRecordSaveDto.setOrgNo(combinerBoxBranchCircuit.getOrgNo());
                            soeRecordSaveDto.setSoeObjectName(combinerBoxBranchCircuit.getCeResName());
                            SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                            soeGenValueJsonObject.setCeCustId(combinerBoxBranchCircuit.getCeCustId());
                            soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                            soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                        }
                    } else {
                        //TODO 查看该汇流箱是否断路告警  如果大于0 说明有 那么复归他
                        count = soeRecordMapper.getRecordNotRecoveryCount(combinerBoxBranchCircuit.getSoeSortNo(),combinerBoxBranchCircuit.getDeviceId());
                        if (count > 0) {
                            SoeRecord recordDo = new SoeRecord();
                            recordDo.setOrgNo(combinerBoxBranchCircuit.getOrgNo());
                            recordDo.setSoeObjectType(1);
                            recordDo.setSoeSortNo(combinerBoxBranchCircuit.getSoeSortNo());
                            recordDo.setSoeObjectId(combinerBoxBranchCircuit.getDeviceId());
                            recordDo.setGmtModified(System.currentTimeMillis());
                            SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                            soeGenValueJsonObject.setCeCustId(combinerBoxBranchCircuit.getCeCustId());
                            recordDo.setSoeGenValue(soeGenValueJsonObject);
                            recordDo.setIsRecovery(true);
                            recordDo.setModifier("sysadmin");
                            recordDo.setSoeRecTime(new Date());
                            soeRecordService.updateSoeRecord(recordDo);
                        }

                    }

                }
        }
        return true;
    }

}
