package com.gaea.iesms.bm.alarm.service.impl;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.gaea.iesms.bm.alarm.mapper.SoeRecordMapper;
import com.gaea.iesms.bm.alarm.model.enums.EconsAlarmEnum;
import com.gaea.iesms.bm.alarm.service.ElectricQuantityAlarmService;
import com.gaea.iesms.core.feign.dto.ElectricQuantityAlarmDTO;
import com.gaea.iesms.core.feign.dto.MeasDataCumFreezeCurveValueDTO;
import com.gaea.iesms.core.model.entity.alarm.SoeRecord;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeGenValueJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

/**
 * @Author wangxiangzhong
 * @Description 电量告警
 * @Date 2023/03/13/13:29
 */
@Service
public class ElectricQuantityAlarmServiceImpl implements ElectricQuantityAlarmService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElectricQuantityAlarmServiceImpl.class);

    //正向有功总
    private final String GEN_WATT_PAET = "gen_watt_paet";

//
//    @Resource
//    private ElectricQuantityAlarmMapper electricQuantityAlarmMapper;
//
//    @Resource
//    private MeasDataService measDataService;

    @Resource
    private SoeRecordMapper soeRecordMapper;

    @Override
    public void insertElectricQuantityAlarm(List<ElectricQuantityAlarmDTO> electricQuantityAlarmDTOList) {
//        Set<String> MEAS_ITEM_CODE_SET = new HashSet<String>() {{
//            add("gen_watt_paet");
//            add("gen_watt_ia");
//            add("gen_watt_ib");
//            add("gen_watt_ic");
//        }};
        for (ElectricQuantityAlarmDTO electricQuantityAlarmDTO : electricQuantityAlarmDTOList) {
            String orgNo = electricQuantityAlarmDTO.getOrgNo();
            Long devMeterId = electricQuantityAlarmDTO.getDevMeterId();
            String devMeterName = electricQuantityAlarmDTO.getDevMeterName();
            //当天凌晨零点的电量的数据
            BigDecimal todayMeasDataValue = null;

            Map<String, MeasDataCumFreezeCurveValueDTO> todayMeasDataMap = electricQuantityAlarmDTO.getTodayMeasDataMap();
            if (CollectionUtils.isNotEmpty(todayMeasDataMap)) {
                todayMeasDataValue = todayMeasDataMap.get(GEN_WATT_PAET).getMeasDataValue();
            }

            //如果  当天凌晨  电量数据为null   则为抄表失败异常
            if (todayMeasDataValue == null) {
                SoeRecord soeRecord = SoeRecord.builder()
                        .orgNo(orgNo)
                        .soeObjectType(1)
                        .soeObjectId(devMeterId)
                        .soeObjectName(devMeterName)
                        .soeSortNo(EconsAlarmEnum.ELEC_ENERGY_METER_READ_FAIL_ABN.getAlarmSortNo())
                        .soeLevel(1)
                        .graveLevel(1)
                        .soeTitle(EconsAlarmEnum.ELEC_ENERGY_METER_READ_FAIL_ABN.getAlarmSortDesc())
                        .soeDesc(EconsAlarmEnum.ELEC_ENERGY_METER_READ_FAIL_ABN.getAlarmSortDesc())
                        .soeGenTime(new Date())
                        .soeGenValue(new SoeGenValueJsonObject())
                        .isRecovery(true)
                        .isSendSms(false)
                        .sendSmsCount(0).build();
                LOGGER.info("抄表失败异常=======>" + soeRecord);
                soeRecordMapper.insert(soeRecord);
            }


            //前一天凌晨零点的电量的数据
            BigDecimal yesterdayMeasDataValue = null;

            Map<String, MeasDataCumFreezeCurveValueDTO> yesterdayMeasDataMap = electricQuantityAlarmDTO.getYesterdayMeasDataMap();
            if (CollectionUtils.isNotEmpty(yesterdayMeasDataMap)) {
                yesterdayMeasDataValue = yesterdayMeasDataMap.get(GEN_WATT_PAET).getMeasDataValue();
            }
            BigDecimal num = null;
            if (todayMeasDataValue != null && yesterdayMeasDataValue!= null){
                //获取当天凌晨和昨日凌晨数据的差值

                num = NumberUtil.sub(todayMeasDataValue, yesterdayMeasDataValue);
                //如果当天凌晨电量的值减去昨日凌晨电量的值小于0   则为电量倒走异常
                if (num.compareTo(BigDecimal.ZERO) == -1) {
                    SoeRecord soeRecord = SoeRecord.builder()
                            .orgNo(orgNo)
                            .soeObjectType(1)
                            .soeObjectId(devMeterId)
                            .soeObjectName(devMeterName)
                            .soeSortNo(EconsAlarmEnum.ELEC_ENERGY_METER_READ_BACK_ABN.getAlarmSortNo())
                            .soeLevel(1)
                            .graveLevel(1)
                            .soeTitle(EconsAlarmEnum.ELEC_ENERGY_METER_READ_BACK_ABN.getAlarmSortDesc())
                            .soeDesc(EconsAlarmEnum.ELEC_ENERGY_METER_READ_BACK_ABN.getAlarmSortDesc())
                            .soeGenTime(new Date())
                            //.soeGenValue(new SoeGenValueJsonObject())
                            .isRecovery(true)
                            .isSendSms(false)
                            .sendSmsCount(0).build();
                    LOGGER.info("电量倒走异常=======>" + soeRecord);
                    soeRecordMapper.insert(soeRecord);
                }
            }

            if (todayMeasDataValue != null && (ObjectUtil.isNotEmpty(electricQuantityAlarmDTO.getEpower()) || ObjectUtil.isNotEmpty(electricQuantityAlarmDTO.getVoltage()))) {
                BigDecimal epower = new BigDecimal(electricQuantityAlarmDTO.getEpower());
                BigDecimal voltage = new BigDecimal(electricQuantityAlarmDTO.getVoltage());
                //日最大可能用电量
                BigDecimal maxPower = epower.multiply(voltage);
                Double a = todayMeasDataValue.divide(maxPower,1, RoundingMode.HALF_UP).doubleValue();
                //电量飞走判断依据  电能表日电量与该电能表日可能最大用电量比值大于60%；
                if (a > 0.6) {
                    SoeRecord soeRecord = SoeRecord.builder()
                            .orgNo(orgNo)
                            .soeObjectType(1)
                            .soeObjectId(devMeterId)
                            .soeObjectName(devMeterName)
                            .soeSortNo(EconsAlarmEnum.ELEC_ENERGY_METER_READ_FLY_ABN.getAlarmSortNo())
                            .soeLevel(1)
                            .graveLevel(1)
                            .soeTitle(EconsAlarmEnum.ELEC_ENERGY_METER_READ_FLY_ABN.getAlarmSortDesc())
                            .soeDesc(EconsAlarmEnum.ELEC_ENERGY_METER_READ_FLY_ABN.getAlarmSortDesc())
                            .soeGenTime(new Date())
                            //.soeGenValue(new SoeGenValueJsonObject())
                            .isRecovery(true)
                            .isSendSms(false)
                            .sendSmsCount(0).build();
                    LOGGER.info("电量飞走异常=======>" + soeRecord);
                    soeRecordMapper.insert(soeRecord);
                }
            }

            List<Integer> count = new ArrayList<>(3);
            Map<String, List<MeasDataCumFreezeCurveValueDTO>> yesterdayAndTodayMeasDataMap = electricQuantityAlarmDTO.getYesterdayAndTodayMeasDataMap();
            if (CollectionUtils.isNotEmpty(yesterdayAndTodayMeasDataMap)) {
                yesterdayAndTodayMeasDataMap.forEach((key, value) -> {
                    if (!key.equals(GEN_WATT_PAET)) {
                        int a = 0;
                        if (CollectionUtils.isNotEmpty(value)) {
                            for (int i = 0; i < value.size(); i++) {
                                if (value.get(i).getMeasDataValue().compareTo(BigDecimal.valueOf(0.1)) == 1) {
                                    a++;
                                }
                            }
                        }
                        count.add(a);
                    }
                });
            }
            //如果当天凌晨电量的值减去昨日凌晨电量的值等于0且该时段内监测到三相电流任意相有3个点大于0.1A   则为电量停走异常
            if ( num !=null && num.compareTo(BigDecimal.ZERO) == 0 && (count.get(0) > 3 || count.get(1) > 3 || count.get(2) > 3)) {
                SoeRecord soeRecord = SoeRecord.builder()
                        .orgNo(orgNo)
                        .soeObjectType(1)
                        .soeObjectId(devMeterId)
                        .soeObjectName(devMeterName)
                        .soeSortNo(EconsAlarmEnum.ELEC_ENERGY_METER_READ_STOP_ABN.getAlarmSortNo())
                        .soeLevel(1)
                        .graveLevel(1)
                        .soeTitle(EconsAlarmEnum.ELEC_ENERGY_METER_READ_STOP_ABN.getAlarmSortDesc())
                        .soeDesc(EconsAlarmEnum.ELEC_ENERGY_METER_READ_STOP_ABN.getAlarmSortDesc())
                        .soeGenTime(new Date())
                        //.soeGenValue(new SoeGenValueJsonObject())
                        .isRecovery(true)
                        .isSendSms(false)
                        .sendSmsCount(0).build();
                LOGGER.info("电量停走异常=======>" + soeRecord);
                soeRecordMapper.insert(soeRecord);
            }

        }

    }
}
