package com.gaea.iesms.bm.alarm.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.gaea.iesms.bm.alarm.mapper.SoeRecordMapper;
import com.gaea.iesms.bm.alarm.model.SoeRecordSaveDto;
import com.gaea.iesms.core.model.enums.alarm.SoeSortEnum;
import com.gaea.iesms.bm.alarm.service.CeSoeSortService;
import com.gaea.iesms.bm.alarm.service.SoeRecordService;
import com.gaea.iesms.bm.alarm.service.TerminalWaringService;
import com.gaea.iesms.core.feign.request.alarm.AlarmTerminalGatherWarningRequest;
import com.gaea.iesms.core.feign.request.alarm.TerminalFaultAlarmRequest;
import com.gaea.iesms.core.model.entity.alarm.SoeRecord;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeGenValueJsonObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @Author wangxiangzhong
 * @Description 终端告警
 * @Date 2023/03/21/9:58
 */
@Slf4j
@Service
public class TerminalWaringServiceImpl implements TerminalWaringService {

    @Resource
    private SoeRecordMapper soeRecordMapper;

    @Resource
    private CeSoeSortService ceSoeSortService;

    @Resource
    private SoeRecordService soeRecordService;

    @Override
    public boolean terminalCollWaring(List<AlarmTerminalGatherWarningRequest> requestList) {
        requestList.forEach(terminalInfoDTO -> {
            String soeSortNo = SoeSortEnum.SOE_TERM_SOUTH_GATHER_FAILURE.getValue();
            Long soeObjectId = terminalInfoDTO.getId();

            //TODO 获取当前时间的时间戳update
            long now = System.currentTimeMillis();

            if (terminalInfoDTO.getGmtMessageUp() != null && terminalInfoDTO.getTermWithSecond() != null ){
                DateTime nowDate = DateUtil.date(now);
                DateTime gmtMessageUp = DateUtil.date(terminalInfoDTO.getGmtMessageUp());
                //TODO now - terminalInfoDTO.getGmtMessageUp()< dates  终端在线
                long betS = (DateUtil.betweenMs(nowDate, gmtMessageUp))/1000;
                if (betS >= terminalInfoDTO.getTermWithSecond()){
                    return;
                }
                //TODO 获取告警表中未复归的数量
                int count = soeRecordMapper.getRecordNotRecoveryCount(soeSortNo,soeObjectId);
                if (terminalInfoDTO.getOnCount() == 0) {
                    if (count <= 0) {
                        log.info("执行插入================》");
                        //TODO 如果没有未复归的 那么新增一条告警
                        SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                        soeRecordSaveDto.setSoeObjectId(terminalInfoDTO.getId());
                        soeRecordSaveDto.setSoeSortNo(SoeSortEnum.SOE_TERM_SOUTH_GATHER_FAILURE.getValue());
                        soeRecordSaveDto.setOrgNo(terminalInfoDTO.getOrgNo());
                        soeRecordSaveDto.setSoeObjectName(terminalInfoDTO.getDevTermName());
                        SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                        soeGenValueJsonObject.setCeCustId(terminalInfoDTO.getCeCustId());
                        soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                        soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                    }
                } else {
                    if (count > 0) {
                        log.info("执行更新================》");
                        //TODO 如果count>0 那么将其复归
                        SoeRecord recordDo = new SoeRecord();
                        recordDo.setOrgNo(terminalInfoDTO.getOrgNo());
                        recordDo.setSoeObjectType(1);
                        recordDo.setSoeSortNo(SoeSortEnum.SOE_TERM_SOUTH_GATHER_FAILURE.getValue());
                        recordDo.setSoeObjectId(soeObjectId);
                        recordDo.setGmtModified(System.currentTimeMillis());
                        SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                        soeGenValueJsonObject.setCeCustId(terminalInfoDTO.getCeCustId());
                        recordDo.setSoeGenValue(soeGenValueJsonObject);
                        recordDo.setIsRecovery(true);
                        recordDo.setModifier("sysadmin");
                        recordDo.setSoeRecTime(new Date());
                        //recordDo.setSoeRecValue(Convert.convert(String.class, maps));
                        soeRecordService.updateSoeRecord(recordDo);
                    }
                }
            }


        });
        return true;
    }

    @Override
    public boolean terminalFaultAlarm(List<TerminalFaultAlarmRequest> terminalFaultAlarmList) {
//        List<TerminalInfoDTO> terminalInfoDTOList = terminalAlarmRequest.getTerminalInfoDTOList();
        for (TerminalFaultAlarmRequest faultAlarmRequest : terminalFaultAlarmList) {
            int isExecute = faultAlarmRequest.getIsExecute();
            if (isExecute == 1){
                continue;
            }
            String soeSortNo = SoeSortEnum.SOE_TERM_COMM_FAILURE.getValue();
            Long soeObjectId = faultAlarmRequest.getTermId();
            //TODO 获取告警表中未复归的数量
            int count = soeRecordMapper.getRecordNotRecoveryCount(soeSortNo,soeObjectId);

            String orgNo = faultAlarmRequest.getOrgNo();
            //TODO 获取当前时间的时间戳
            long now = System.currentTimeMillis();
            //TODO 获取一个小时的时间戳
            long dates = 60 * 60 * 1000;
            //TODO 判断终端是否在线 （当前时间减去最近一次上送时间是否大于一个小时）
            if (now - faultAlarmRequest.getGmtMessageUp() <= dates) {
                //TODO 如果count>0的话 那么说明此用户之前存在告警信息
                // 那么 将此条告警信息 复归 如果等于0 则不做任何操作
                if (count > 0) {
                    SoeRecord recordDo = new SoeRecord();
                    recordDo.setOrgNo(orgNo);
                    recordDo.setSoeObjectType(1);
                    recordDo.setSoeSortNo("SOE_TERM_COMM_FAILURE");
                    recordDo.setSoeObjectId(Long.valueOf(faultAlarmRequest.getTermId()));
                    recordDo.setIsRecovery(true);
                    recordDo.setSoeRecTime(new Date());
                    soeRecordService.updateSoeRecord(recordDo);
                }
                //TODO 如果大于1个小时 （终端不在线）
            } else {
                //TODO 如果小于等于0 说明 该用户没有未复归的告警 那么就新生成一条告警数据
                if (count <= 0) {
                    SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                    soeRecordSaveDto.setSoeObjectId(faultAlarmRequest.getTermId());
                    soeRecordSaveDto.setSoeSortNo(SoeSortEnum.SOE_TERM_COMM_FAILURE.getValue());
                    soeRecordSaveDto.setOrgNo(faultAlarmRequest.getOrgNo());
                    soeRecordSaveDto.setSoeObjectName(faultAlarmRequest.getDevTermName());
                    SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                    soeGenValueJsonObject.setCeCustId(faultAlarmRequest.getCeCustId());
                    soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                    soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                }
            }
        }

        return true;
    }

//    public void insertSoeRecord(SoeRecordSaveDto soeRecordSaveDto){
//        // 查出顺序事件分类信息
//        String soeSortNo = soeRecordSaveDto.getSoeSortNo();
//        CeSoeSort ceSoeSort =  ceSoeSortService.getSoeSortBySortNo(soeSortNo);
//        //TermAndMeterInfoDto soeSortDo = bmIesmsSoeSortMapper.getSoeSortBySortNo(map);
//        SoeRecord recordDo = new SoeRecord();
//        recordDo.setId(SNOWFLAKE_GENERATOR.next());
//        recordDo.setOrgNo(soeRecordSaveDto.getOrgNo());
//        recordDo.setSoeObjectType(ceSoeSort.getSoeObjectType());
//        recordDo.setSoeObjectId(soeRecordSaveDto.getSoeObjectId());
//        recordDo.setSoeObjectName(soeRecordSaveDto.getSoeObjectName());
//        recordDo.setSoeSortNo(soeRecordSaveDto.getSoeSortNo());
//        recordDo.setSoeTitle(ceSoeSort.getSoeSortName());
//        recordDo.setGraveLevel(soeRecordSaveDto.getGraveLevel() == null ? 1 : soeRecordSaveDto.getGraveLevel());
//        // 有告警描述则用告警描述，否则用告警编码自己的通用描述
//        recordDo.setSoeDesc(StrUtil.isNotEmpty(soeRecordSaveDto.getSoeDesc()) ? soeRecordSaveDto.getSoeDesc() : ceSoeSort.getSoeSortDesc());
//        recordDo.setSoeGenTime(new Date());
//        // 事件对象类型：20 - 用能资源
//        recordDo.setSoeGenValue(soeRecordSaveDto.getSoeGenValue());
////        if (20 == iesmsSoeSort.getSoeObjectType()) {
////            params.put("soeGenvalue", map.get("soeGenValue"));
////            recordDo.setSoeGenValue(params);
////        } else {
////            recordDo.setSoeGenValue("{}");
////        }
//        recordDo.setCreator("sysadmin");
//        recordDo.setGmtCreate(System.currentTimeMillis());
//        recordDo.setModifier("sysadmin");
//        recordDo.setGmtModified(System.currentTimeMillis());
//
//        soeRecordService.insertSoeRecordAndPushRedis(recordDo);
//    }
}
