package com.gaea.iesms.bm.alarm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.gaea.iesms.bm.alarm.mapper.SoeRecordMapper;
import com.gaea.iesms.bm.alarm.model.SoeRecordSaveDto;
import com.gaea.iesms.core.model.enums.alarm.SoeSortEnum;
import com.gaea.iesms.bm.alarm.service.SoeRecordService;
import com.gaea.iesms.bm.alarm.service.VoltageService;
import com.gaea.iesms.core.feign.request.alarm.PowerFactorRequest;
import com.gaea.iesms.core.feign.request.alarm.VoltageAlarmRequest;
import com.gaea.iesms.core.feign.response.datacenter.MeasDataInsFreezeCurveValue;
import com.gaea.iesms.core.model.entity.alarm.SoeRecord;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeGenValueJsonObject;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

/**
 * @Author wangxiangzhong
 * @Description 电压告警相关service
 * @Date 2023/05/09/17:12
 */
@Service
public class VoltageServiceImpl implements VoltageService {

    @Resource
    private SoeRecordMapper soeRecordMapper;

    @Resource
    private SoeRecordService soeRecordService;

    @Override
    public void voltageOutPhase(List<VoltageAlarmRequest> voltageAlarmRequestList) {
        for (VoltageAlarmRequest voltageAlarmRequest : voltageAlarmRequestList) {
            int count = 0;
            List<List<MeasDataInsFreezeCurveValue>> threePhaseVoltageList = voltageAlarmRequest.getThreePhaseVoltage();
            if (CollectionUtil.isNotEmpty(threePhaseVoltageList)) {
                for (int i = 1; i < 4; i++) {
                    List<BigDecimal> paramsList = new ArrayList<>();
                    paramsList.add(threePhaseVoltageList.get(1).get(threePhaseVoltageList.get(1).size() - i).getMeasDataValue());
                    paramsList.add(threePhaseVoltageList.get(2).get(threePhaseVoltageList.get(2).size() - i).getMeasDataValue());
                    paramsList.add(threePhaseVoltageList.get(0).get(threePhaseVoltageList.get(0).size() - i).getMeasDataValue());
                    //TODO 判断电压断相
                    int flag = this.getWaringCount(paramsList, BigDecimal.valueOf(0.6 * 220));
                    //TODO 如果flag 等于1 说明达到了告警条件了 count+1
                    if (flag == 1) {
                        count = count + 1;
                    }
                }
//
                //TODO 如果连续三个点都是 （如果其中有两相电压某一个大于等于 K*标准电压 并且另一个小于'K*标准电压'）继续往下走
                if (count == 3) {
                    //TODO 查询告警表里面是否有记录
                    count  = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_VOLT_LOSSPHASE_ALARM.getValue(), voltageAlarmRequest.getDeviceId());
                    //TODO count<=0说明没记录
                    if (count <= 0) {
                        SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                        soeRecordSaveDto.setOrgNo(voltageAlarmRequest.getOrgNo());
                        soeRecordSaveDto.setSoeObjectId(voltageAlarmRequest.getDeviceId());
                        soeRecordSaveDto.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_VOLT_LOSSPHASE_ALARM.getValue());
                        soeRecordSaveDto.setSoeObjectName(voltageAlarmRequest.getCeResName());
                        SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                        soeGenValueJsonObject.setCeCustId(voltageAlarmRequest.getCeCustId());
                        soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                        soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                    }
                } else {
                    //TODO 查看该逆变器是否存在电压断相告警  如果大于0 则复归此告警
                    count  = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_VOLT_LOSSPHASE_ALARM.getValue(), voltageAlarmRequest.getDeviceId());
                    if (count > 0) {
                        SoeRecord recordDo = new SoeRecord();
                        recordDo.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_VOLT_LOSSPHASE_ALARM.getValue());
                        recordDo.setSoeObjectId(voltageAlarmRequest.getDeviceId());
                        recordDo.setGmtModified(System.currentTimeMillis());
                        recordDo.setIsRecovery(true);
                        recordDo.setModifier("sysadmin");
                        recordDo.setSoeRecTime(new Date());
                        soeRecordService.updateSoeRecord(recordDo);
                    }
                }
            }
        }

    }

    @Override
    public void voltageLimit(List<VoltageAlarmRequest> voltageAlarmRequestList) {
        BigDecimal K = new BigDecimal("1.1");
        BigDecimal value = K.multiply(BigDecimal.valueOf(220));
        for (VoltageAlarmRequest voltageAlarmRequest : voltageAlarmRequestList) {
            List<List<MeasDataInsFreezeCurveValue>> threePhaseVoltageList = voltageAlarmRequest.getThreePhaseVoltage();
            int count = 0;
            if (CollectionUtil.isNotEmpty(threePhaseVoltageList)) {
                for (int i = 1; i < 4; i++) {
                    BigDecimal measValuea = threePhaseVoltageList.get(0).get(threePhaseVoltageList.get(0).size() - i).getMeasDataValue();
                    BigDecimal measValueb = threePhaseVoltageList.get(1).get(threePhaseVoltageList.get(1).size() - i).getMeasDataValue();
                    BigDecimal measValuec = threePhaseVoltageList.get(2).get(threePhaseVoltageList.get(2).size() - i).getMeasDataValue();
                    //TODO 如果连续三个点的任意一项电压大于 参考电压 count+1
                    if ((measValuea.compareTo(value) > 0 && measValueb.compareTo(value) > 0 && measValuec.compareTo(value) > 0)) {
                        count++;
                    }
                }

                if (count == 3) {
                    //TODO 查询告警表里面是否有记录
                    count  = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_VOLT_OUTLIMIT_ALARM.getValue(), voltageAlarmRequest.getDeviceId());
                    //TODO count<=0说明没记录
                    if (count <= 0) {
                        SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                        soeRecordSaveDto.setOrgNo(voltageAlarmRequest.getOrgNo());
                        soeRecordSaveDto.setSoeObjectId(voltageAlarmRequest.getDeviceId());
                        soeRecordSaveDto.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_VOLT_OUTLIMIT_ALARM.getValue());
                        soeRecordSaveDto.setSoeObjectName(voltageAlarmRequest.getCeResName());
                        SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                        soeGenValueJsonObject.setCeCustId(voltageAlarmRequest.getCeCustId());
                        soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                        soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                    }
                } else {
                    //TODO 查看该逆变器是否存在电压越限告警  如果大于0 说明有跟新状态 复归掉 没有则不管
                    count  = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_VOLT_OUTLIMIT_ALARM.getValue(), voltageAlarmRequest.getDeviceId());
                    if (count > 0) {
                        SoeRecord recordDo = new SoeRecord();
                        recordDo.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_VOLT_OUTLIMIT_ALARM.getValue());
                        recordDo.setSoeObjectId(voltageAlarmRequest.getDeviceId());
                        recordDo.setGmtModified(System.currentTimeMillis());
                        recordDo.setIsRecovery(true);
                        recordDo.setModifier("sysadmin");
                        recordDo.setSoeRecTime(new Date());
                        soeRecordService.updateSoeRecord(recordDo);
                    }
                }
            }
        }

    }

    @Override
    public void powerFactor(List<PowerFactorRequest> powerFactorRequestList) {
        for (PowerFactorRequest powerFactorRequest : powerFactorRequestList) {
            // 正向有功总
            BigDecimal forwardActivePower = powerFactorRequest.getForwardActivePower();
            // 正向无功总
            BigDecimal forwardReactivePower = powerFactorRequest.getForwardReactivePower();
            if (ObjectUtil.isNotEmpty(forwardActivePower) && forwardActivePower.compareTo(BigDecimal.ZERO) > 0) {
                //TODO 求正向有功平方与正向无功总平方的和
                BigDecimal sumValue = (forwardActivePower.multiply(forwardActivePower)).add(forwardReactivePower.multiply(forwardReactivePower));
                //TODO 求正向有功总除 （正向有功平方与正向无功总平方的和的平方根）
                BigDecimal k = forwardActivePower.divide(BigDecimal.valueOf(Math.sqrt(sumValue.doubleValue())), 2, RoundingMode.HALF_UP);
                int count;
                if (k.compareTo(BigDecimal.valueOf(0.5)) > 0) {
                    //TODO 查询告警表里面是否有记录
                    count  = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_POWER_FACTOR_ABN.getValue(), powerFactorRequest.getDeviceId());

                    //TODO count<=0说明没记录
                    if (count <= 0) {
                        SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                        soeRecordSaveDto.setOrgNo(powerFactorRequest.getOrgNo());
                        soeRecordSaveDto.setSoeObjectId(powerFactorRequest.getDeviceId());
                        soeRecordSaveDto.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_POWER_FACTOR_ABN.getValue());
                        soeRecordSaveDto.setSoeObjectName(powerFactorRequest.getCeResName());
                        SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                        soeGenValueJsonObject.setCeCustId(powerFactorRequest.getCeCustId());
                        soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                        soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                    }
                } else {
                    //TODO 查看该逆变器是否存在功率因素异常告警  如果大于0 说明有跟新状态 复归掉 没有则不管
                    count  = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_POWER_FACTOR_ABN.getValue(), powerFactorRequest.getDeviceId());
                    if (count > 0) {
                        SoeRecord recordDo = new SoeRecord();
                        recordDo.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_POWER_FACTOR_ABN.getValue());
                        recordDo.setSoeObjectId(powerFactorRequest.getDeviceId());
                        recordDo.setGmtModified(System.currentTimeMillis());
                        recordDo.setIsRecovery(true);
                        recordDo.setModifier("sysadmin");
                        recordDo.setSoeRecTime(new Date());
                        soeRecordService.updateSoeRecord(recordDo);
                    }
                }
            }
        }
    }

    @Override
    public void voltageUnBalance(List<VoltageAlarmRequest> voltageAlarmRequestList) {

        for (VoltageAlarmRequest voltageAlarmRequest : voltageAlarmRequestList) {
            int flag = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_VOLT_LOSSPHASE_ALARM.getValue(),voltageAlarmRequest.getDeviceId());
            if (flag <= 0) {
                //TODO 获取三相电压信息
                List<List<MeasDataInsFreezeCurveValue>> threePhaseVoltageList = voltageAlarmRequest.getThreePhaseVoltage();
                int count = 0;
                if (CollectionUtil.isNotEmpty(threePhaseVoltageList)) {
                    for (int i = 1; i < 4; i++) {
                        BigDecimal measValuea = threePhaseVoltageList.get(0).get(threePhaseVoltageList.get(0).size() - i).getMeasDataValue();
                        BigDecimal measValueb = threePhaseVoltageList.get(1).get(threePhaseVoltageList.get(1).size() - i).getMeasDataValue();
                        BigDecimal measValuec = threePhaseVoltageList.get(2).get(threePhaseVoltageList.get(2).size() - i).getMeasDataValue();
                        if (measValueb.compareTo(BigDecimal.ZERO) > 0 && measValuec.compareTo(BigDecimal.ZERO) > 0 && measValuea.compareTo(BigDecimal.ZERO) > 0) {
                            List<BigDecimal> maxOrMinList = new ArrayList<>();
                            maxOrMinList.add(measValueb);
                            maxOrMinList.add(measValuec);
                            maxOrMinList.add(measValuea);
                            Map<String, BigDecimal> resultMap = this.getMaxAndMin(maxOrMinList);
                            if (resultMap.get("max") != null && resultMap.get("max").compareTo(BigDecimal.ZERO) != 0) {
                                //TODO 最大值减最小值除最大值 大于0.1 count+1
                                if (((resultMap.get("max").subtract(resultMap.get("min"))).divide(resultMap.get("max"), 2, RoundingMode.HALF_UP).compareTo(BigDecimal.valueOf(0.1))) == 1) {
                                    count++;
                                }
                            }
                        }
                    }

                    //TODO 如果count>3 即：a，b，c三相电压都不平衡
                    if (count == 3) {
                        //TODO 判断告警表里面是否有间隔电压不平衡的告警记录
                        count = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_VOLT_IMBALANCE_ALARM.getValue(),voltageAlarmRequest.getDeviceId());
                        //TODO count<=0说明没记录 则新增一条告警
                        if (count <= 0) {
                            SoeRecordSaveDto soeRecordSaveDto = new SoeRecordSaveDto();
                            soeRecordSaveDto.setOrgNo(voltageAlarmRequest.getOrgNo());
                            soeRecordSaveDto.setSoeObjectId(voltageAlarmRequest.getDeviceId());
                            soeRecordSaveDto.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_VOLT_IMBALANCE_ALARM.getValue());
                            soeRecordSaveDto.setSoeObjectName(voltageAlarmRequest.getCeResName());
                            SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
                            soeGenValueJsonObject.setCeCustId(voltageAlarmRequest.getCeCustId());
                            soeRecordSaveDto.setSoeGenValue(soeGenValueJsonObject);
                            soeRecordService.insertSoeRecordAndPushMq(soeRecordSaveDto);
                        }
                    } else {
                        //TODO 查看该逆变器是否存在电压不平衡告警  如果大于0 说明有更新状态 复归掉 没有则不做任何操作
                        count = soeRecordMapper.getRecordNotRecoveryCount(SoeSortEnum.SOE_DEV_DIST_INTERVAL_VOLT_IMBALANCE_ALARM.getValue(),voltageAlarmRequest.getDeviceId());
                        if (count > 0) {
                            SoeRecord recordDo = new SoeRecord();
                            recordDo.setSoeSortNo(SoeSortEnum.SOE_DEV_DIST_INTERVAL_POWER_FACTOR_ABN.getValue());
                            recordDo.setSoeObjectId(voltageAlarmRequest.getDeviceId());
                            recordDo.setGmtModified(System.currentTimeMillis());
                            recordDo.setIsRecovery(true);
                            recordDo.setModifier("sysadmin");
                            recordDo.setSoeRecTime(new Date());
                            soeRecordService.updateSoeRecord(recordDo);
                        }
                    }
                }
            }
        }

    }

    /**
     * 判断电压断相
     */
    public int getWaringCount(List<BigDecimal> list, BigDecimal value) {
        int count = 0;
        for (BigDecimal values : list) {
            //TODO 任一相电压小于K*参比电压，另两相电压中任一相电压不小于K*参比电压。连续3个点。K = 60%，参比电压 = 220V
            //  也就是说如果count=1 那么就产生了告警
            //  value(K*参比电压) 任一项电压小于k*参比电压 count+1
            if (values.compareTo(value) < 0) {
                count = count + 1;
            }
        }
        return count;
    }

    /**
     * 获取最大最小值
     */
    public Map<String, BigDecimal> getMaxAndMin(List<BigDecimal> maxOrMinList) {
        BigDecimal max = maxOrMinList.get(0);
        BigDecimal min = maxOrMinList.get(0);
        Map<String, BigDecimal> maps = new HashMap<>();
        for (BigDecimal value : maxOrMinList) {
            if (min.compareTo(value) > 0) {
                min = value;
            }
            if (max.compareTo(value) < 0) {
                max = value;
            }
        }
        maps.put("max", max);
        maps.put("min", min);
        return maps;
    }
}
