package com.gaea.iesms.bm.alarm.controller;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.base.ResponseResult;
import com.easesource.data.bean.Pager;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.alarm.model.request.AddSubsInfoRequest;
import com.gaea.iesms.bm.alarm.model.request.SubsInfoPageRequest;
import com.gaea.iesms.bm.alarm.model.request.UpdateSubsInfoRequest;
import com.gaea.iesms.bm.alarm.model.response.vo.OpsSubsInfoPageVo;
import com.gaea.iesms.bm.alarm.service.OpsSubsInfoOrgService;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Author wangxiangzhong
 * @Description 告警订阅信息
 * @Date 2023/03/27/10:10
 */
@Api(tags = "告警订阅信息")
@RestController
@RequestMapping("/subs/info")
public class OpsSubsInfoController {


    @Resource
    private OpsSubsInfoOrgService opsSubsInfoOrgService;

    @ApiOperation(value = "新增告警订阅")
    @PostMapping("/addSubscribe")
    public R addOpsSubsInfo(@RequestBody AddSubsInfoRequest addSubsInfoRequest){
        int flag =  opsSubsInfoOrgService.addOpsSubsInfo(addSubsInfoRequest);
        if (flag>0){
            return R.ok();
        }
        return R.failure();
    }

    @ApiOperation(value = "查询告警订阅列表")
    @PostMapping("/listSubscribe")
    public R<OpsSubsInfoPageVo> listSubscribe(@RequestBody SubsInfoPageRequest subsInfoPageRequest){
        OpsSubsInfoPageVo opsSubsInfoPage =  opsSubsInfoOrgService.listSubscribe(subsInfoPageRequest);
        return R.ok(opsSubsInfoPage);
    }

    @PostMapping(value = "/updateSubscribe")
    @ApiOperation("告警订阅得修改")
    public R updateSubscribe(@RequestBody UpdateSubsInfoRequest updateSubsInfoRequest) {
        return opsSubsInfoOrgService.updateSubscribe(updateSubsInfoRequest);
    }

    /**
     * 告警订阅得删除
     **/
    @PostMapping(value = "/delSubscribe")
    @ApiOperation("告警订阅得删除")
    public R delSubscribe(@RequestBody List<String> ids) {
        return  opsSubsInfoOrgService.delSubsInfo(ids);
    }

}
