package com.gaea.iesms.bm.alarm.controller;

import com.gaea.base.core.R;
import com.gaea.iesms.bm.alarm.model.response.dto.SoeSortDto;
import com.gaea.iesms.bm.alarm.model.request.AlarmSortPageRequest;
import com.gaea.iesms.bm.alarm.model.request.SoeSortRequest;
import com.gaea.iesms.bm.alarm.model.response.vo.SoeSortPageVo;
import com.gaea.iesms.bm.alarm.model.response.vo.SoeSortTreeVo;
import com.gaea.iesms.bm.alarm.model.response.vo.SoeSortVo;
import com.gaea.iesms.bm.alarm.service.CeSoeSortService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Author wangxiangzhong
 * @Description 告警分类管理
 * @Date 2023/03/24/10:29
 */
@Api(tags = "告警分类管理")
@RestController
@RequestMapping("/soe/sort")
public class SoeSortController {

    @Resource
    private CeSoeSortService ceSoeSortService;

    @ApiOperation(value = "告警分类列表查询")
    @PostMapping("/list")
    public R<SoeSortPageVo> listSoeSort(@RequestBody AlarmSortPageRequest alarmSortPageRequest){
        SoeSortPageVo soeSortPageVo = ceSoeSortService.listSoeSort(alarmSortPageRequest);
        return R.ok(soeSortPageVo);
    }

    @ApiOperation(value = "告警分类新增或修改")
    @PostMapping("/addOrUpdate")
    public R addSoeSort(@RequestBody SoeSortRequest soeSortRequest){
        boolean flag =  ceSoeSortService.addSoeSort(soeSortRequest);
       if (flag){
           return R.ok();
       }
        return R.failure();
    }

    @ApiOperation(value = "根据分类告警id查询详情")
    @GetMapping("/gerSoeSortInfoById")
    public R<SoeSortVo> gerSoeSortInfoById(Long id){
        SoeSortDto soeSortDto =   ceSoeSortService.gerSoeSortInfoById(id);
        SoeSortVo soeSortVo = new SoeSortVo();
        BeanUtils.copyProperties(soeSortDto,soeSortVo);
        return R.ok(soeSortVo);
    }

    @ApiOperation(value = "根据sortNo查询详情")
    @GetMapping("/gerSoeSortInfoBySortNo")
    public R<SoeSortVo> gerSoeSortInfoBySortNo(String sortNo){
        SoeSortDto soeSortDto =   ceSoeSortService.gerSoeSortInfoBySortNo(sortNo);
        SoeSortVo soeSortVo = new SoeSortVo();
        BeanUtils.copyProperties(soeSortDto,soeSortVo);
        return R.ok(soeSortVo);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "sortBizProps", value = "业务属性。模块对应的参数类型：energy_mgmt_flag:用能管理；distribution_ops_flag：配电代运维；" +
                    "metering_billing_flag：多表计量计费（能源集抄）；elec_purchase_flag：购售电管理；distributed_pv_flag：分布式光伏",
                    dataType = "String", required = false)
    })
    @ApiOperation(value = "告警类型查询--返回树结构")
    @GetMapping("/tree")
    public R<List<SoeSortTreeVo>> tree(@RequestParam(value = "sortBizProps",required = false) String sortBizProps){
        List<SoeSortTreeVo> soeSortTreeVoList = ceSoeSortService.treeSoeSort(sortBizProps);
        return R.ok(soeSortTreeVoList);
    }
}
