package com.gaea.iesms.bm.alarm.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gaea.iesms.core.feign.request.alarm.AlarmRecordPageRequest;
import com.gaea.iesms.bm.alarm.model.response.vo.SoeDevMeterAlarmVo;
import com.gaea.iesms.core.model.entity.alarm.SoeRecord;
import com.gaea.iesms.core.model.entity.archive.CeDevice;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
* @author wangxiangzhong
* @description 针对表【soe_record(顺序事件记录 )】的数据库操作Mapper
* @createDate 2023-03-07 09:36:13
*/
@Mapper
public interface SoeRecordMapper extends BaseMapper<SoeRecord> {

    int getRecordNotRecoveryCount(@Param("soeSortNo") String soeSortNo,@Param("soeObjectId") Long soeObjectId);

    Page<SoeRecord> selectSoeRecordPage(@Param("page")Page<SoeRecord> page, @Param("alarmRecordRequest")AlarmRecordPageRequest alarmRecordRequest);

    int getMeterSoeCount(@Param("soeObjectId")String soeObjectId, @Param("soeSortNo")String soeSortNo);

    List<SoeDevMeterAlarmVo> getSoeDevMeterAlarmList(SoeDevMeterAlarmVo alarmVo);

    SoeRecord getSoeRecord(@Param("params") AlarmRecordPageRequest alarmRecordPageRequest);

    void updateSoeRecord(@Param("params")SoeRecord alarmDo);

    SoeRecordOnOffAlarmDo getDevMeterInfo(@Param("params")Map<String, String> map);

    SoeRecordOnOffAlarmDo getDevMeterInfoByMeasePointId(@Param("params")Map<String, String> map);

    List<CeDevice> getCeDeviceInfo(@Param("devMeterId") Long devMeterId);
}




