package com.gaea.iesms.bm.alarm.model.request;


import com.gaea.iesms.core.model.jsonobject.alarm.SoeSortBizpropsJsonObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Author wangxiangzhong
 * @Description 顺序事件分类
 * @Date 2023/03/24/15:28
 */
@Data
@ApiModel(description = "顺序事件分类入参")
public class SoeSortRequest {
    @ApiModelProperty(value = "事件分类id")
    private Long id;

    @ApiModelProperty(value = "事件分类编号", required = true)
    private String soeSortNo;

    @ApiModelProperty(value = "事件分类名称", required = true)
    private String soeSortName;

    @ApiModelProperty(value = "事件分类别名", required = true)
    private String soeSortAlias;

    @ApiModelProperty(value = "事件分类说明", required = true)
    private String soeSortDesc;

    @ApiModelProperty(value = "事件分类诊断算法说明", required = true)
    private String soeSortDaDesc;

    @ApiModelProperty(value = "用能管理标记", example = "true")
    private Boolean energyMgmtFlag=false;

    @ApiModelProperty(value = "配电代运维标记", example = "true")
    private Boolean distributionOpsFlag=false;

    @ApiModelProperty(value = "多表计量计费（能源集抄）标记", example = "true")
    private Boolean meteringBillingFlag=false;

    @ApiModelProperty(value = "购售电管理标记", example = "true")
    private Boolean elecPurchaseFlag=false;

    @ApiModelProperty(value = "分布式光伏标记", example = "true")
    private Boolean distributedPvFlag=false;

    @ApiModelProperty(value = "事件分类大类，编码SOE_SORT_CLASS_CODE")
    private String soeSortClass;

    @ApiModelProperty(value = "事件对象类型;1 - 采集终端设备；2 - 采集器设备；3 - 量测表计设备；10 - 用能点；20 - 用能资源；", required = true)
    private Integer soeObjectType;

}
