package com.gaea.iesms.bm.alarm.model.response.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeGenValueJsonObject;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeRecValueJsonObject;
import com.gaea.base.typehandler.JsonObjectTypeHandler;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @Author wangxiangzhong
 * @Description TODO
 * @Date 2023/03/21/15:45
 */
@Data
public class SoeRecordDto {

    private Long id;
    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 事件对象类型
     */
    private Integer soeObjectType;

    /**
     * 事件对象标识
     */
    private Long soeObjectId;

    /**
     * 事件对象名称
     */
    private String soeObjectName;

    /**
     * 事件分类编号
     */
    private String soeSortNo;

    /**
     * 事件等级 1 - 一般事件；2 - 次要事件；3 - 重要事件；
     */
    private Integer soeLevel;

    /**
     * 严重等级 1 - 轻微；2 - 普通；3 - 严重；
     */
    private Integer graveLevel;

    /**
     * 事件标题
     */
    private String soeTitle;

    /**
     * 事件说明
     */
    private String soeDesc;

    /**
     * 事件发生时间
     */
    private Date soeGenTime;

    /**
     * 事件发生值
     */
    @TableField(value = "soe_gen_value", typeHandler = JsonObjectTypeHandler.class)
    private SoeGenValueJsonObject soeGenValue;

    /**
     * 是否复归
     */
    private Boolean isRecovery;

    /**
     * 事件复归时间
     */
    private Date soeRecTime;

    /**
     * 事件复归值
     */

    @TableField(value = "soe_rec_value", typeHandler = JsonObjectTypeHandler.class)
    private SoeRecValueJsonObject soeRecValue;

    /**
     * 是否发送短信
     */
    private Boolean isSendSms;

    /**
     * 处理状态
     */
    private Integer handleStatus;

    /**
     * 确认时间
     */
    private Date handleTime;
    /**
     * 确认描述
     */
    private String archiveDesc;
    /**
     * 发送短信次数
     */
    private Integer sendSmsCount;

        /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 是否有效
     */
    private Integer isValid;

    /**
     * 创建人 系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间 为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人 系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间 为0表示为空
     */
    private Long gmtModified;

    /**
     * 失效人 系统用户表用户编号字段（user_no）
     */
    private String invalider;

    /**
     * 失效时间 为0表示为空
     */
    private Long gmtInvalid;

    /**
     * 版本号 用于乐观锁
     */
    private Integer version;
}
