package com.gaea.iesms.bm.alarm.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.gaea.iesms.bm.alarm.mapper.SoeRecordMapper;
import com.gaea.iesms.core.feign.request.alarm.AlarmRecordPageRequest;
import com.gaea.iesms.bm.alarm.model.response.vo.SoeDevMeterAlarmVo;
import com.gaea.iesms.bm.alarm.service.DataCenterAlarmService;
import com.gaea.iesms.bm.alarm.service.SoeRecordService;
import com.gaea.iesms.bm.alarm.service.SoeThresholdSetService;
import com.gaea.iesms.core.feign.request.alarm.SoeRecordOnOffAlarmRequest;
import com.gaea.iesms.core.feign.service.DataCenterCommonService;
import com.gaea.iesms.core.model.entity.alarm.SoeRecord;
import com.gaea.iesms.core.model.entity.alarm.SoeThresholdSet;
import com.gaea.iesms.core.model.entity.archive.CeDevice;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeGenValueJsonObject;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeRecValueJsonObject;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDo;
import com.iesms.bizprocessors.common.util.MeasStatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * @Author wangxiangzhong
 * @Description 数据中心告警
 * @Date 2023/05/10/16:43
 */
@Service
public class DataCenterAlarmServiceImpl implements DataCenterAlarmService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SoeRecordMapper soeRecordMapper;
    @Resource
    private SoeRecordService soeRecordService;

    @Resource
    private SoeThresholdSetService soeThresholdSetService;
    @Resource
    private DataCenterCommonService dataCenterCommonService;


    @Override
    public void dataCenterDevMeterAlarm(List<SoeRecordOnOffAlarmRequest> soeRecordOnOffAlarmRequestList) {

        List<SoeRecord> soeRecordList = new ArrayList<>();
        for (SoeRecordOnOffAlarmRequest soeRecordOnOffAlarmRequest : soeRecordOnOffAlarmRequestList) {
            SoeRecord soeRecord = new SoeRecord();
            BeanUtils.copyProperties(soeRecordOnOffAlarmRequest, soeRecord);
            String devMeterCommAddr = soeRecordOnOffAlarmRequest.getDevMeterCommAddr();
            String devTermCommAddr = soeRecordOnOffAlarmRequest.getDevTermCommAddr();
            Long measPointId = soeRecordOnOffAlarmRequest.getMeasPointId();
            String soeSortNo = soeRecordOnOffAlarmRequest.getSoeSortNo();
            String soeTitle = soeRecordOnOffAlarmRequest.getSoeTitle();

            // 查询表计地址
            SoeRecordOnOffAlarmDo devMeterInfo = null;
            if (StrUtil.isNotEmpty(devMeterCommAddr)) {
                Map<String, String> map = new HashMap<>();
                map.put("devMeterCommAddr", devMeterCommAddr);
                map.put("devTermCommAddr", devTermCommAddr);
                devMeterInfo = soeRecordMapper.getDevMeterInfo(map);
            } else {
                Map<String, String> map = new HashMap<>();
                map.put("devMeterCommAddr", devMeterCommAddr);
                map.put("measPointId", measPointId.toString());
                devMeterInfo = soeRecordMapper.getDevMeterInfoByMeasePointId(map);
            }

            //如果表计地址不存在则返回
            if (ObjectUtil.isEmpty(devMeterInfo)) {
                return;
            }

            String orgNo = devMeterInfo.getOrgNo();
            Long devMeterId = devMeterInfo.getId();
            String devMeterName = devMeterInfo.getDevMeterName();
            //根据表计标识获取设备信息
            List<CeDevice> ceDeviceList = soeRecordMapper.getCeDeviceInfo(devMeterId);
            // 查询是否有未复归的告警，如果有则判断是否复归，如果没有则插入
            String alarmInfo = null;
            //Map<String, Object> objectMap = new HashMap<>();
            AlarmRecordPageRequest alarmRecordPageRequest = new AlarmRecordPageRequest();
            if (ObjectUtil.isNotEmpty(ceDeviceList)) {
                CeDevice ceDevice = ceDeviceList.get(0);
                soeRecord.setSoeObjectType(20);
                soeRecord.setSoeObjectId(ceDevice.getId());
                //TODO 设备名称
                //soeRecord.setSoeObjectName(ceDevice.get());
                alarmRecordPageRequest.setSoeObjectId(ceDevice.getId());

            } else {
                soeRecord.setSoeObjectType(3);
                soeRecord.setSoeObjectId(devMeterId);
                soeRecord.setSoeObjectName(devMeterName);
                alarmRecordPageRequest.setSoeObjectId(devMeterId);
            }

            alarmRecordPageRequest.setIsRecovery("0");
            alarmRecordPageRequest.setSoeSortNo(soeSortNo);
            SoeRecord beforeOffAlarmDo = soeRecordMapper.getSoeRecord(alarmRecordPageRequest);

            Boolean onOff = soeRecordOnOffAlarmRequest.getOnOff();
            soeRecord.setOrgNo(orgNo);
            soeRecord.setSoeSortNo(soeSortNo);
            soeRecord.setSoeGenTime(new Date());
            SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
            soeGenValueJsonObject.setSoeGenvalue("1");
            soeRecord.setSoeGenValue(soeGenValueJsonObject);
            //判断报文告警上送状态,true为应生成告警,false为复归告警
            if (onOff) {
                //若不存在未复归告警则插入告警
                if (ObjectUtil.isNotEmpty(beforeOffAlarmDo)) {
                    return;
                } else {
                    soeRecord.setIsRecovery(false);
                    soeRecordList.add(soeRecord);
                }
            } else {
                //若存在未复归告警则复归该告警
                if (ObjectUtil.isNotEmpty(beforeOffAlarmDo)) {
                    beforeOffAlarmDo.setIsRecovery(true);
                    beforeOffAlarmDo.setSoeRecTime(new Date());
//                    Map<String, Object> map = new HashMap<>();
//                    map.put("soeRecValue", "0");
//                    String soeRecValue = JsonConvertUtils.convertToString(map);
//                    beforeOffAlarmDo.setSoeRecValue(soeRecValue);
                    SoeGenValueJsonObject soeGenValue = beforeOffAlarmDo.getSoeGenValue();
                    soeGenValue.setSoeGenvalue("0");
                    beforeOffAlarmDo.setSoeGenValue(soeGenValue);
                    beforeOffAlarmDo.setGmtModified(System.currentTimeMillis());
                    soeRecordMapper.updateSoeRecord(beforeOffAlarmDo);
                } else {
                    return;
                }
            }
        }
        soeRecordService.insertSoeRecordOnOffAlarmBatch(soeRecordList);

    }

    @Override
    public void dataCenterBoundSoeRecord() throws Exception {
//        if (this.logger.isDebugEnabled()) {
//            this.logger.debug("调用上下限告警 参数：{}", measDataService);
//        }
        //List<SoeThresholdSetAlarmDo> thresholdSetAlarmDo = this.soeRecordOnOffAlarmDao.getSoeThresholdSetAlarmDo();
        List<SoeThresholdSet> soeThresholdSetList = soeThresholdSetService.list();
        if (soeThresholdSetList != null) {
            Map<Long, List<SoeThresholdSet>> mapList = (Map) soeThresholdSetList.stream().collect(Collectors.groupingBy(SoeThresholdSet::getCeDevId));
            //List<SoeRecordOnOffAlarmDo> alarmDoList = new ArrayList();
            List<SoeRecord> alarmDoList = new ArrayList<>();
            mapList.forEach((ceDeviceId, alarmList) -> {
                SoeDevMeterAlarmVo alarmVo = new SoeDevMeterAlarmVo();
                alarmVo.setCeDeviceId(ceDeviceId);
                List<SoeDevMeterAlarmVo> devMeterAlarmList = soeRecordMapper.getSoeDevMeterAlarmList(alarmVo);
                if (devMeterAlarmList != null && devMeterAlarmList.size() >= 1) {
                    Set<String> measIdList = this.getMeasIdList(devMeterAlarmList);
                    String orgNo = ((SoeDevMeterAlarmVo) devMeterAlarmList.get(0)).getOrgNo();
                    String ceResName = ((SoeDevMeterAlarmVo) devMeterAlarmList.get(0)).getCeResName();
                    Set<String> measItemCodeSet = new TreeSet();
                    alarmList.forEach((meterAlarmVo) -> {
                        measItemCodeSet.add(meterAlarmVo.getMeasItemCode());
                    });
                    //TODO 远程调用数据中心
                    Map<String, BigDecimal> decimalMap = dataCenterCommonService.getValueSum(measItemCodeSet,measIdList).getData();
                    //Map<String, BigDecimal> decimalMap = MeasStatUtil.getValueSum(measItemCodeSet, measIdList, measDataService);
                    alarmList.forEach((alarm) -> {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("告警的设备id是：", ceDeviceId);
                        }

                        String measItemCode = alarm.getMeasItemCode();
                        String similar = measItemCode.substring(0, 10);
                        List<String> list = new ArrayList();
                        measItemCodeSet.forEach((code) -> {
                            String simi = code.substring(0, 10);
                            if (simi.equals(similar)) {
                                list.add(code);
                            }

                        });
                        String measItemCode2 = alarm.getMeasItemCode();
                        BigDecimal upperLimit = alarm.getUpperLimit();
                        BigDecimal upperUpperLimit = alarm.getUpperUpperLimit();
                        BigDecimal downLimit = alarm.getDownLimit();
                        BigDecimal downDownLimit = alarm.getDownDownLimit();
                        Object value = decimalMap.get(measItemCode);
                        if (value != null) {
                            String measItemAlias = alarm.getMeasItemAlias();
                            BigDecimal currValue = new BigDecimal(value.toString());
                            String sortNo;
                            SoeRecord recordOnOffAlarmDo;
                            SoeRecord alarmDo;
                            HashMap map2;
                            if (upperUpperLimit != null) {
                                sortNo = "SOE_" + measItemCode.toUpperCase() + "_OUUL_ALARM";
                                AlarmRecordPageRequest alarmRecordPageRequest = new AlarmRecordPageRequest();
                                alarmRecordPageRequest.setSoeObjectId(ceDeviceId);
                                alarmRecordPageRequest.setIsRecovery("0");
                                alarmRecordPageRequest.setSoeSortNo(sortNo);
                                recordOnOffAlarmDo = soeRecordMapper.getSoeRecord(alarmRecordPageRequest);
                                if (recordOnOffAlarmDo == null && currValue.compareTo(upperUpperLimit) > 0) {
                                    alarmDo = new SoeRecord();
                                    alarmDo.setOrgNo(orgNo);
                                    alarmDo.setSoeObjectId(ceDeviceId);
                                    alarmDo.setSoeObjectName(ceResName);
                                    alarmDo.setSoeObjectType(20);
                                    alarmDo.setSoeRecTime(new Date());
                                    alarmDo.setSoeSortNo(measItemCode);
//                                    map2 = new HashMap();
//                                    map2.put(measItemCode2 + "_curr_value", currValue);
//                                    map2.put(measItemCode2 + "_set_value", upperUpperLimit);
//                                    HashMap finalMap = map2;
//                                    measItemCodeSet.forEach((code) -> {
//                                        BigDecimal decimal = (BigDecimal) decimalMap.get(code);
//                                        finalMap.put(code, decimal);
//                                    });
//                                    SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
//                                    String itemValve = JsonConvertUtils.convertToString(map2);
//                                    soeGenValueJsonObject.setItemValue(itemValve);
                                    SoeGenValueJsonObject genValue = this.getGenValue(measItemCodeSet, measItemCode2, currValue, upperUpperLimit, decimalMap);
                                    alarmDo.setSoeGenValue(genValue);
                                    this.comp(alarmDo, measItemAlias, upperUpperLimit, currValue, 1);
                                    if (!alarmDo.getSoeSortNo().equals("")) {
                                        alarmDoList.add(alarmDo);
                                    }
                                } else if (currValue.compareTo(upperUpperLimit) <= 0) {
                                    alarmDo = new SoeRecord();
                                    alarmDo.setOrgNo(orgNo);
                                    alarmDo.setSoeObjectId(ceDeviceId);
                                    alarmDo.setSoeObjectName(ceResName);
                                    alarmDo.setIsRecovery(true);
                                    SoeRecValueJsonObject soeRecValue = this.getSoeRecValue(measItemCodeSet, measItemCode2, currValue, upperLimit, decimalMap);
                                    alarmDo.setSoeRecValue(soeRecValue);
                                    alarmDo.setSoeRecTime(new Date());
                                    alarmDo.setSoeSortNo(sortNo);
                                    alarmDo.setGmtModified(System.currentTimeMillis());
                                    soeRecordMapper.updateSoeRecord(alarmDo);
                                }
                            }

                            if (upperLimit != null) {
                                sortNo = "SOE_" + measItemCode.toUpperCase() + "_OUL_ALARM";
                                AlarmRecordPageRequest alarmRecordPageRequest = new AlarmRecordPageRequest();
                                alarmRecordPageRequest.setSoeObjectId(ceDeviceId);
                                alarmRecordPageRequest.setIsRecovery("0");
                                alarmRecordPageRequest.setSoeSortNo(sortNo);
                                recordOnOffAlarmDo = soeRecordMapper.getSoeRecord(alarmRecordPageRequest);
                                //recordOnOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("告警的信息为================：", recordOnOffAlarmDo);
                                }

                                if (recordOnOffAlarmDo == null && currValue.compareTo(upperLimit) > 0) {
                                    alarmDo = new SoeRecord();
                                    alarmDo.setOrgNo(orgNo);
                                    alarmDo.setSoeObjectId(ceDeviceId);
                                    alarmDo.setSoeObjectName(ceResName);
                                    alarmDo.setSoeSortNo(measItemCode);
                                    alarmDo.setSoeObjectType(20);
                                    alarmDo.setSoeGenTime(new Date());
                                    SoeRecValueJsonObject soeRecValue = this.getSoeRecValue(measItemCodeSet, measItemCode2, currValue, upperLimit, decimalMap);
                                    alarmDo.setSoeRecValue(soeRecValue);
                                    this.comp(alarmDo, measItemAlias, upperLimit, currValue, 2);
                                    if (!alarmDo.getSoeSortNo().equals("")) {
                                        alarmDoList.add(alarmDo);
                                    }
                                } else if (currValue.compareTo(upperLimit) <= 0) {
                                    alarmDo = new SoeRecord();
                                    alarmDo.setOrgNo(orgNo);
                                    alarmDo.setSoeObjectId(ceDeviceId);
                                    alarmDo.setSoeObjectName(ceResName);
                                    alarmDo.setIsRecovery(true);
                                    SoeRecValueJsonObject soeRecValue = this.getSoeRecValue(measItemCodeSet, measItemCode2, currValue, upperLimit, decimalMap);
                                    alarmDo.setSoeRecValue(soeRecValue);
                                    alarmDo.setSoeRecTime(new Date());
                                    alarmDo.setSoeSortNo(sortNo);
                                    alarmDo.setGmtModified(System.currentTimeMillis());
                                    soeRecordMapper.updateSoeRecord(alarmDo);
                                }
                            }

                            if (downLimit != null) {

                                sortNo = "SOE_" + measItemCode.toUpperCase() + "_OLL_ALARM";
                                AlarmRecordPageRequest alarmRecordPageRequest = new AlarmRecordPageRequest();
                                alarmRecordPageRequest.setSoeObjectId(ceDeviceId);
                                alarmRecordPageRequest.setIsRecovery("0");
                                alarmRecordPageRequest.setSoeSortNo(sortNo);
                                recordOnOffAlarmDo = soeRecordMapper.getSoeRecord(alarmRecordPageRequest);
                                //recordOnOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                                if (recordOnOffAlarmDo == null && currValue.compareTo(downLimit) < 0) {
                                    alarmDo = new SoeRecord();
                                    alarmDo.setOrgNo(orgNo);
                                    alarmDo.setSoeObjectId(ceDeviceId);
                                    alarmDo.setSoeObjectName(ceResName);
                                    alarmDo.setSoeSortNo(measItemCode);
                                    alarmDo.setSoeGenTime(new Date());
                                    SoeGenValueJsonObject genValue = this.getGenValue(measItemCodeSet, measItemCode2, currValue, downLimit, decimalMap);
                                    alarmDo.setSoeGenValue(genValue);

                                    this.comp(alarmDo, measItemAlias, downLimit, currValue, 3);
                                    if (!alarmDo.getSoeSortNo().equals("")) {
                                        alarmDoList.add(alarmDo);
                                    }
                                } else if (currValue.compareTo(downLimit) >= 0) {
                                    alarmDo = new SoeRecord();
                                    alarmDo.setOrgNo(orgNo);
                                    alarmDo.setSoeObjectId(ceDeviceId);
                                    alarmDo.setSoeObjectName(ceResName);
                                    alarmDo.setIsRecovery(true);
                                    SoeRecValueJsonObject soeRecValue = this.getSoeRecValue(measItemCodeSet, measItemCode2, currValue, downLimit, decimalMap);
                                    alarmDo.setSoeRecValue(soeRecValue);
                                    alarmDo.setSoeRecTime(new Date());
                                    alarmDo.setSoeSortNo(sortNo);
                                    alarmDo.setGmtModified(System.currentTimeMillis());
                                    soeRecordMapper.updateSoeRecord(alarmDo);
                                }
                            }

                            if (downDownLimit != null) {
                                sortNo = "SOE_" + measItemCode.toUpperCase() + "_OLLL_ALARM";
                                AlarmRecordPageRequest alarmRecordPageRequest = new AlarmRecordPageRequest();
                                alarmRecordPageRequest.setSoeObjectId(ceDeviceId);
                                alarmRecordPageRequest.setIsRecovery("0");
                                alarmRecordPageRequest.setSoeSortNo(sortNo);
                                recordOnOffAlarmDo = soeRecordMapper.getSoeRecord(alarmRecordPageRequest);
                                // recordOnOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                                if (recordOnOffAlarmDo == null && currValue.compareTo(downDownLimit) < 0) {
                                    alarmDo = new SoeRecord();
                                    alarmDo.setOrgNo(orgNo);
                                    alarmDo.setSoeObjectId(ceDeviceId);
                                    alarmDo.setSoeObjectName(ceResName);
                                    alarmDo.setSoeSortNo(measItemCode);
                                    alarmDo.setSoeGenTime(new Date());
                                    SoeGenValueJsonObject genValue = this.getGenValue(measItemCodeSet, measItemCode2, currValue, downDownLimit, decimalMap);
                                    alarmDo.setSoeGenValue(genValue);
                                    this.comp(alarmDo, measItemAlias, downDownLimit, currValue, 4);
                                    if (!alarmDo.getSoeSortNo().equals("")) {
                                        alarmDoList.add(alarmDo);
                                    }
                                } else if (currValue.compareTo(downDownLimit) >= 0) {
                                    alarmDo = new SoeRecord();
                                    alarmDo.setOrgNo(orgNo);
                                    alarmDo.setSoeObjectId(ceDeviceId);
                                    alarmDo.setSoeObjectName(ceResName);
                                    alarmDo.setIsRecovery(true);
                                    SoeRecValueJsonObject soeRecValue = this.getSoeRecValue(measItemCodeSet, measItemCode2, currValue, downDownLimit, decimalMap);
                                    alarmDo.setSoeRecValue(soeRecValue);
                                    alarmDo.setSoeRecTime(new Date());
                                    alarmDo.setSoeSortNo(sortNo);
                                    alarmDo.setGmtModified(System.currentTimeMillis());
                                    soeRecordMapper.updateSoeRecord(alarmDo);
                                }
                            }

                        }
                    });
                }
            });
            if (alarmDoList.size() > 0) {
                ArrayList<SoeRecord> list = (ArrayList) alarmDoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> {
                    return new TreeSet(Comparator.comparing(SoeRecord::getSoeSortNo));
                }), ArrayList::new));
                soeRecordService.insertSoeRecordOnOffAlarmBatch(list);
            }

        }
    }

    private SoeGenValueJsonObject getGenValue(Set<String> measItemCodeSet,
                                              String measItemCode2,
                                              BigDecimal currValue,
                                              BigDecimal limit,
                                              Map<String, BigDecimal> decimalMap) {
        HashMap<String,Object> map2 = new HashMap();
        map2.put(measItemCode2 + "_curr_value", currValue);
        map2.put(measItemCode2 + "_set_value", limit);
        HashMap finalMap = map2;
        measItemCodeSet.forEach((code) -> {
            BigDecimal decimal = (BigDecimal) decimalMap.get(code);
            finalMap.put(code, decimal);
        });
        SoeGenValueJsonObject soeGenValueJsonObject = new SoeGenValueJsonObject();
        soeGenValueJsonObject.setItemValue(map2);
        return soeGenValueJsonObject;
    }

    private SoeRecValueJsonObject getSoeRecValue(Set<String> measItemCodeSet, String measItemCode2, BigDecimal currValue, BigDecimal limit, Map<String, BigDecimal> decimalMap) {
        HashMap<String,Object> map2 = new HashMap();
        map2.put(measItemCode2 + "_curr_value", currValue);
        map2.put(measItemCode2 + "_set_value", limit);
        measItemCodeSet.forEach((code) -> {
            BigDecimal decimal = (BigDecimal) decimalMap.get(code);
            map2.put(code, decimal);
        });
        SoeRecValueJsonObject soeRecValueJsonObject = new SoeRecValueJsonObject();
        soeRecValueJsonObject.setItemRecValue(map2);
        return soeRecValueJsonObject;
    }

    private void comp(SoeRecord alarmDo, String measItemAlias, BigDecimal limitValue, BigDecimal currValue, int level) {
        if (currValue != null && limitValue != null) {
            int i = currValue.compareTo(limitValue);
            Boolean limit1 = i > 0;
            Boolean limit2 = i < 0;
            StringBuffer sb = new StringBuffer();
            sb.append("SOE_");
            String soeSortNo = alarmDo.getSoeSortNo().toUpperCase();
            sb.append(soeSortNo);
            String mess = "";
            String valueDes = "";
            String toString = currValue.toString();
            String zeroAndDot = MeasStatUtil.subZeroAndDot(toString);
            String subZeroAndDot = MeasStatUtil.subZeroAndDot(limitValue.toString());
            switch (level) {
                case 1:
                    if (limit1) {
                        mess = " 越上上限告警";
                        sb.append("_OUUL_ALARM");
                        valueDes = "上上限设置值：" + subZeroAndDot + " , 当前值：" + zeroAndDot;
                    } else {
                        sb = null;
                    }
                    break;
                case 2:
                    if (limit1) {
                        mess = " 越上限告警";
                        sb.append("_OUL_ALARM");
                        valueDes = "上限设置值：" + subZeroAndDot + " , 当前值：" + zeroAndDot;
                    } else {
                        sb = null;
                    }
                    break;
                case 3:
                    if (limit2) {
                        mess = " 越下限告警";
                        sb.append("_OLL_ALARM");
                        valueDes = "下限设置值：" + subZeroAndDot + " , 当前值：" + zeroAndDot;
                    } else {
                        sb = null;
                    }
                    break;
                case 4:
                    if (limit2) {
                        mess = " 越下下限告警";
                        sb.append("_OLLL_ALARM");
                        valueDes = "下下限设置值：" + subZeroAndDot + " , 当前值：" + zeroAndDot;
                    } else {
                        sb = null;
                    }
            }

            if (sb != null) {
                alarmDo.setSoeTitle(measItemAlias + "告警");
                alarmDo.setSoeDesc(measItemAlias + mess + " ," + valueDes);
                alarmDo.setSoeSortNo(sb.toString());
            } else {
                alarmDo.setSoeTitle("");
                alarmDo.setSoeDesc("");
                alarmDo.setSoeSortNo("");
            }

        }
    }

    public  Set<String> getMeasIdList(List<SoeDevMeterAlarmVo> devMeterAlarmList) {
        Map<String, Long> measMaps = new ConcurrentHashMap();
        devMeterAlarmList.forEach((meterAlarmVo) -> {
            Long measPointId = meterAlarmVo.getMeasPointId();
            String measPointIds = meterAlarmVo.getMeasPointIdList();
            String[] measPointIds2 = null;
            if (measPointIds != null && !measPointIds.equals("[]") && !measPointIds.equals("[0]")) {
                measPointIds2 = (String[]) JsonConvertUtils.convertFromString(measPointIds, String[].class);
            }

            if (measPointIds2 != null && measPointIds2.length > 0) {
                String[] var5 = measPointIds2;
                int var6 = measPointIds2.length;

                for (int var7 = 0; var7 < var6; ++var7) {
                    String measId = var5[var7];
                    measMaps.put(measId, Long.valueOf(measId));
                }
            }

            if (measPointId != null) {
                measMaps.put(measPointId.toString(), measPointId);
            }

        });
        Set<String> strings = measMaps.keySet();
        return strings;
    }

}
