package com.gaea.iesms.bm.alarm.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.iesms.bm.alarm.mapper.SoeRecordHandleMapper;
import com.gaea.iesms.bm.alarm.service.SoeRecordHandleService;
import com.gaea.iesms.core.model.entity.alarm.SoeRecordHandle;
import com.gaea.spring.cloud.starter.util.AuthUtils;
import com.gaea.spring.cloud.starter.vo.UserDetail;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Date;

/**
* @description 针对表【soe_record_handle(顺序事件处理信息;)】的数据库操作Service实现
* @createDate 2023-03-21 16:55:58
*/
@Service
public class SoeRecordHandleServiceImpl extends ServiceImpl<SoeRecordHandleMapper, SoeRecordHandle>
    implements SoeRecordHandleService {

    @Override
    public int insertSoeRecordHandle(String id, String archiveDesc) {
        SoeRecordHandle soeRecordHandle = new SoeRecordHandle();
        String userNo = AuthUtils.getUserDetail().getUserNo();
        soeRecordHandle.setId(Long.valueOf(id));
        soeRecordHandle.setHandleStatus(9);
        soeRecordHandle.setAssigner(userNo);
        soeRecordHandle.setAssignTime(new Date());
        soeRecordHandle.setAssignDesc("");
        soeRecordHandle.setAssignAttach("");
        soeRecordHandle.setAcceptor(userNo);
        soeRecordHandle.setAssignTime(new Date());
        soeRecordHandle.setAcceptAttach("");
        soeRecordHandle.setAcceptDesc("");
        soeRecordHandle.setHandler(userNo);
        soeRecordHandle.setHandleAttach("");
        soeRecordHandle.setHandleDesc("");
        soeRecordHandle.setHandleTime(new Date());
        soeRecordHandle.setArchiver(userNo);
        soeRecordHandle.setArchiveAttach("");
        if (!StringUtils.isEmpty(archiveDesc)){
            soeRecordHandle.setArchiveDesc(archiveDesc);
        }
        soeRecordHandle.setArchiveTime(new Date());
        soeRecordHandle.setSortSn(1);
        soeRecordHandle.setIsValid(true);
        soeRecordHandle.setCreator(userNo);
        soeRecordHandle.setGmtCreate((new Date()).getTime());
        soeRecordHandle.setModifier(userNo);
        soeRecordHandle.setGmtModified((new Date()).getTime());
        soeRecordHandle.setGmtInvalid((new Date()).getTime());
        soeRecordHandle.setInvalider(userNo);
        soeRecordHandle.setVersion(1);
        int result = this.baseMapper.insert(soeRecordHandle);
        return result;
    }

}




