package com.gaea.iesms.bm.alarm.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.generator.SnowflakeGenerator;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.gaea.iesms.bm.alarm.mapper.SoeRecordMapper;
import com.gaea.iesms.bm.alarm.model.MqConstants;
import com.gaea.iesms.bm.alarm.model.SoeRecordSaveDto;
import com.gaea.iesms.bm.alarm.model.response.dto.AlarmDto;
import com.gaea.iesms.bm.alarm.model.response.dto.SoeRecordDto;
import com.gaea.iesms.bm.alarm.model.request.AlarmObjectPageRequest;
import com.gaea.iesms.core.feign.request.alarm.AlarmRecordPageRequest;
import com.gaea.iesms.bm.alarm.model.response.vo.AlarmVo;
import com.gaea.iesms.core.feign.request.alarm.PushAlarmRequest;
import com.gaea.iesms.core.feign.response.alarm.SoeRecordPageVo;
import com.gaea.iesms.core.feign.response.alarm.SoeRecordVo;
import com.gaea.iesms.bm.alarm.service.CeSoeSortService;
import com.gaea.iesms.bm.alarm.service.SoeRecordService;
import com.gaea.iesms.bm.alarm.service.SoeThresholdSetService;
import com.gaea.iesms.core.model.entity.alarm.CeSoeSort;
import com.gaea.iesms.core.model.entity.alarm.SoeRecord;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeGenValueJsonObject;
import com.gaea.utils.ConvertUtils;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
* @author wangxiangzhong
* @description 针对表【soe_record(顺序事件记录 )】的数据库操作Service实现
* @createDate 2023-03-07 09:36:13
*/
@Slf4j
@Service
public class SoeRecordServiceImpl extends ServiceImpl<SoeRecordMapper, SoeRecord>
    implements SoeRecordService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final List<String> SORT_NO_LIST = Arrays.asList("ABNORMAL_LOAD_ALARM", "CHANGE_HIGH_VOLTAGE_ALARM", "CHANGE_LOW_VOLTAGE_ALARM", "THREE_IMBALANCE_ELECTRICITY_ALARM");

    private static final List<String> MONTH_SORT_NO_LIST = Arrays.asList("ABNORMAL_ELECTRICITY_ALARM", "ABNORMAL_POWER_ALARM", "ELECTRICITY_PRICE_ANOMALIES_ALARM", "POWER_FACTOR_ANOMALIES_ALARM");

    private static final SnowflakeGenerator SNOWFLAKE_GENERATOR = new SnowflakeGenerator();
    @Resource
    private SoeRecordMapper soeRecordMapper;

    @Resource
    private CeSoeSortService ceSoeSortService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @Resource
    private SoeThresholdSetService soeThresholdSetService;

    @Resource
    private RabbitTemplate rabbitTemplate;


    @Override
    public boolean insertSoeRecordAndPushMq(SoeRecordSaveDto soeRecordSaveDto) {
        // 查出顺序事件分类信息
        String soeSortNo = soeRecordSaveDto.getSoeSortNo();
        CeSoeSort ceSoeSort =  ceSoeSortService.getSoeSortBySortNo(soeSortNo);
        SoeRecord soeRecord = new SoeRecord();
        soeRecord.setId(SNOWFLAKE_GENERATOR.next());
        soeRecord.setOrgNo(soeRecordSaveDto.getOrgNo());
        soeRecord.setSoeObjectType(ceSoeSort.getSoeObjectType());
        soeRecord.setSoeObjectId(soeRecordSaveDto.getSoeObjectId());
        soeRecord.setSoeObjectName(soeRecordSaveDto.getSoeObjectName());
        soeRecord.setSoeSortNo(soeRecordSaveDto.getSoeSortNo());
        soeRecord.setSoeTitle(ceSoeSort.getSoeSortName());
        soeRecord.setGraveLevel(soeRecordSaveDto.getGraveLevel() == null ? 1 : soeRecordSaveDto.getGraveLevel());
        // 有告警描述则用告警描述，否则用告警编码自己的通用描述
        soeRecord.setSoeDesc(StrUtil.isNotEmpty(soeRecordSaveDto.getSoeDesc()) ? soeRecordSaveDto.getSoeDesc() : ceSoeSort.getSoeSortDesc());
        soeRecord.setSoeGenTime(new Date());
        // 事件对象类型：20 - 用能资源
        soeRecord.setSoeGenValue(soeRecordSaveDto.getSoeGenValue());
//        if (20 == iesmsSoeSort.getSoeObjectType()) {
//            params.put("soeGenvalue", map.get("soeGenValue"));
//            recordDo.setSoeGenValue(params);
//        } else {
//            recordDo.setSoeGenValue("{}");
//        }
        soeRecord.setCreator("sysadmin");
        soeRecord.setGmtCreate(System.currentTimeMillis());
        soeRecord.setModifier("sysadmin");
        soeRecord.setGmtModified(System.currentTimeMillis());
        LambdaQueryWrapper<SoeRecord> query = Wrappers.<SoeRecord>lambdaQuery()
                .eq(SoeRecord::getOrgNo, soeRecord.getOrgNo())
                .eq(SoeRecord::getSoeObjectType, soeRecord.getSoeObjectType())
                .eq(SoeRecord::getSoeObjectId, soeRecord.getSoeObjectId())
                .eq(SoeRecord::getSoeSortNo, soeRecord.getSoeSortNo())
                .eq(SoeRecord::getIsRecovery, false);
        SoeRecord soe = this.baseMapper.selectOne(query);
        if (soe != null) {
            if (SORT_NO_LIST.contains(soeRecord.getSoeSortNo()) && DateUtil.offsetDay(soe.getSoeGenTime(), 2).before(new Date())) {
                revertSoeRecord(soeRecord);
            }
            if (MONTH_SORT_NO_LIST.contains(soeRecord.getSoeSortNo())) {
                if (DateUtil.month(new Date()) != DateUtil.month(soe.getSoeGenTime())) {
                    revertSoeRecord(soeRecord);
                }
            }
            return true;
        }
        this.baseMapper.insert(soeRecord);
        // 推送mq
        pushMq(soeRecord);
        //this.pushRedis(soeRecord);
        return true;
    }
//    public boolean pushRedis(SoeRecord soeRecord) {
//        AlarmDto alarmDto = AlarmDto.builder()
//                .orgNo(soeRecord.getOrgNo())
//                .deviceName(soeRecord.getSoeObjectName())
//                .graveLevel(soeRecord.getGraveLevel())
//                .soeSortName(soeRecord.getSoeTitle())
//                .soeSortNo(soeRecord.getSoeSortNo())
//                .build();
//        stringRedisTemplate.convertAndSend("IESMS_SOE_EVENT", JSONUtil.toJsonStr(alarmDto));
//        return true;
//    }

    public boolean pushMq(SoeRecord soeRecord){
        AlarmDto alarmDto = AlarmDto.builder()
                .orgNo(soeRecord.getOrgNo())
                .deviceName(soeRecord.getSoeObjectName())
                .graveLevel(soeRecord.getGraveLevel())
                .soeSortName(soeRecord.getSoeTitle())
                .soeSortNo(soeRecord.getSoeSortNo())
                .build();
        rabbitTemplate.convertAndSend(MqConstants.ALARM_EXCHANGE,MqConstants.ALARM_ROUTING_KEY,alarmDto);
        return true;
    }

    @Override
    public int updateSoeRecord(SoeRecord soeRecord) {
        LambdaQueryWrapper<SoeRecord> query = Wrappers.<SoeRecord>lambdaQuery()
                .eq(SoeRecord::getOrgNo, soeRecord.getOrgNo())
                .eq(SoeRecord::getSoeObjectId, soeRecord.getSoeObjectId())
                .eq(SoeRecord::getSoeObjectType, soeRecord.getSoeObjectType())
                .eq(SoeRecord::getSoeSortNo, soeRecord.getSoeSortNo())
                .eq(SoeRecord::getIsRecovery, false);
        return this.baseMapper.update(soeRecord, query);
    }


    @Override
    public void insertSoeRecordOnOffAlarmBatch(List<SoeRecord> list) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 告警记录插入开始 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>记录数为：" + list.size());
        }

        if (list != null) {
            list.removeIf(Objects::isNull);
            if (list.size() >= 1) {
                long time1 = System.currentTimeMillis();
                list.forEach((alarmDo) -> {
                    //alarmDo.setId(this.idGenerator.nextId());
                    alarmDo.setSoeLevel(3);
                    alarmDo.setGraveLevel(3);
                    alarmDo.setIsSendSms(false);
                    alarmDo.setSendSmsCount(0);
                    alarmDo.setSortSn(1);
                    alarmDo.setIsValid(true);
                    if (alarmDo.getSoeGenValue() == null){
                        alarmDo.setSoeGenValue(new SoeGenValueJsonObject());
                    }
                    alarmDo.setGmtCreate(System.currentTimeMillis());
                    alarmDo.setGmtModified(System.currentTimeMillis());
                    alarmDo.setCreator("alarmSystem");
                    alarmDo.setCreator("alarmSystem");
                    alarmDo.setInvalider("alarmSystem");
                    alarmDo.setModifier("alarmSystem");
                    alarmDo.setGmtInvalid(0L);
                    alarmDo.setVersion(0);
                });
                this.saveBatch(list);
//                for(int i = 0; i < list.size(); ++i) {
//                    this.soeRecordOnOffAlarmDao.insertSoeRecordOnOffAlarmDo((SoeRecordOnOffAlarmDo)list.get(i));
//
//                }
                long time2 = System.currentTimeMillis();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 告警记录插入结束>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>告警记录插入时间为：" + (time2 - time1) / 1000L + "秒");
                    this.logger.debug(" ===================================开合告警推送开始===================================");
                }

                list.forEach((alarm) -> {
                    AlarmVo alarmVo = new AlarmVo();
                    alarmVo.setOrgNo(alarm.getOrgNo());
                    alarmVo.setDeviceName(alarm.getSoeObjectName());
                    alarmVo.setGraveLevel("3");
                    alarmVo.setSoeSortNo(alarm.getSoeSortNo());
                    alarmVo.setSoeSortName(alarm.getSoeDesc());
                    this.stringRedisTemplate.convertAndSend("IESMS_SOE_EVENT", JsonConvertUtils.convertToString(alarmVo));
                });
                long time3 = System.currentTimeMillis();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("告警推送时间为：" + (time3 - time2) / 1000L);
                    this.logger.debug(" ===================================开合告警推送结束 ==================================");
                }

            }
        }
    }



    @Override
    public SoeRecordDto findSoeRecordById(Long id) {
        SoeRecord soeRecord = this.baseMapper.selectById(id);
        SoeRecordDto soeRecordDto = new SoeRecordDto();
        BeanUtils.copyProperties(soeRecord,soeRecordDto);
        return soeRecordDto;
    }


    /**
     * 根据告警对象的id查询告警列表数据
     * @param alarmObjectPageRequest
     * @return
     */
    @Override
    public SoeRecordPageVo getSoeRecordByObjectId(AlarmObjectPageRequest alarmObjectPageRequest) {
        Page<SoeRecord> page = new Page<>(alarmObjectPageRequest.getPageNumber(), alarmObjectPageRequest.getPageSize());
        QueryWrapper<SoeRecord> wrapper = new QueryWrapper<>();
        wrapper.eq("soe_object_id", alarmObjectPageRequest.getObjectId());
        Page<SoeRecord> soeRecordPage = baseMapper.selectPage(page, wrapper);
        List<SoeRecord> records = soeRecordPage.getRecords();
        List<SoeRecordVo> soeRecordVoList = ConvertUtils.toList(SoeRecordVo.class, records);
        SoeRecordPageVo soeRecordPageVo = new SoeRecordPageVo();
        soeRecordPageVo.setSoeRecordVo(soeRecordVoList);
        soeRecordPageVo.setTotal(soeRecordPage.getTotal());
        return soeRecordPageVo;
    }

    /**
     * 告警记录列表查询
     * @param alarmRecordPageRequest
     * @return
     */
    @Override
    public SoeRecordPageVo listSoeRecord(AlarmRecordPageRequest alarmRecordPageRequest) {
        Page<SoeRecord> page = new Page<>(alarmRecordPageRequest.getPageNumber(), alarmRecordPageRequest.getPageSize());
//        QueryWrapper<SoeRecord> wrapper = new QueryWrapper<>();
//        wrapper.likeRight("org_no",alarmRecordPageRequest.getOrgNo());
//        if (StringUtils.isNotEmpty(alarmRecordPageRequest.getIsRecovery())){
//            wrapper.eq("is_recovery",alarmRecordPageRequest.getIsRecovery());
//        }
//        if (StringUtils.isNotEmpty(alarmRecordPageRequest.getStartDate()) && StringUtils.isNotEmpty(alarmRecordPageRequest.getEndDate())){
//            wrapper.between("soe_gen_time", alarmRecordPageRequest.getStartDate(), alarmRecordPageRequest.getEndDate());
//        }

        Page<SoeRecord> soeRecordPage = this.baseMapper.selectSoeRecordPage(page, alarmRecordPageRequest);
        List<SoeRecord> records = soeRecordPage.getRecords();
        List<SoeRecordVo> soeRecordVoList = ConvertUtils.toList(SoeRecordVo.class, records);
        SoeRecordPageVo soeRecordPageVo = new SoeRecordPageVo();
        soeRecordPageVo.setSoeRecordVo(soeRecordVoList);
        soeRecordPageVo.setTotal(soeRecordPage.getTotal());
        return soeRecordPageVo;
    }

    @Override
    public void pushAlarm(PushAlarmRequest pushAlarmRequest) {
        // 查出顺序事件分类信息
        String soeSortNo = pushAlarmRequest.getSoeSortNo();
        CeSoeSort ceSoeSort =  ceSoeSortService.getSoeSortBySortNo(soeSortNo);
        SoeRecord soeRecord = new SoeRecord();
        if (pushAlarmRequest.getId() == null){
            soeRecord.setId(SNOWFLAKE_GENERATOR.next());
        }else {
            soeRecord.setId(pushAlarmRequest.getId());
        }
        soeRecord.setOrgNo(pushAlarmRequest.getOrgNo());
        soeRecord.setSoeObjectType(ceSoeSort.getSoeObjectType());
        soeRecord.setSoeObjectId(pushAlarmRequest.getSoeObjectId());
        soeRecord.setSoeObjectName(pushAlarmRequest.getSoeObjectName());
        soeRecord.setSoeSortNo(pushAlarmRequest.getSoeSortNo());
        soeRecord.setSoeTitle(ceSoeSort.getSoeSortName());
        soeRecord.setGraveLevel(pushAlarmRequest.getGraveLevel() == null ? 1 : pushAlarmRequest.getGraveLevel());
        // 有告警描述则用告警描述，否则用告警编码自己的通用描述
        soeRecord.setSoeDesc(StrUtil.isNotEmpty(pushAlarmRequest.getSoeDesc()) ? pushAlarmRequest.getSoeDesc() : ceSoeSort.getSoeSortDesc());
        soeRecord.setSoeGenTime(pushAlarmRequest.getSoeGenTime());
        soeRecord.setSoeGenValue(pushAlarmRequest.getSoeGenValue());
        soeRecord.setCreator("sysadmin");
        soeRecord.setGmtCreate(System.currentTimeMillis());
        soeRecord.setModifier("sysadmin");
        soeRecord.setGmtModified(System.currentTimeMillis());
        LambdaQueryWrapper<SoeRecord> query = Wrappers.<SoeRecord>lambdaQuery()
                .eq(SoeRecord::getOrgNo, soeRecord.getOrgNo())
                .eq(SoeRecord::getSoeObjectType, soeRecord.getSoeObjectType())
                .eq(SoeRecord::getSoeObjectId, soeRecord.getSoeObjectId())
                .eq(SoeRecord::getSoeSortNo, soeRecord.getSoeSortNo())
                .eq(SoeRecord::getIsRecovery, false);
        query.orderByDesc(SoeRecord::getSoeGenTime);
        query.last("limit 1");
        SoeRecord soe = this.baseMapper.selectOne(query);
        if (soe == null){
            soeRecord.setIsRecovery(pushAlarmRequest.getIsRecovery());
            this.baseMapper.insert(soeRecord);
            // 推送mq
            pushMq(soeRecord);
            return;
        }

        // 存在判断是否需要复归，复归的则更新
        Boolean isRecovery = pushAlarmRequest.getIsRecovery();
        if (isRecovery!=null && isRecovery){
            Date soeRecTime = pushAlarmRequest.getSoeRecTime();
            soe.setIsRecovery(true);
            if (soeRecTime == null){
                soe.setSoeRecTime(new Date());
            }else {
                soe.setSoeRecTime(soeRecTime);
            }
          this.baseMapper.updateById(soe);
        }
    }

    public void revertSoeRecord(SoeRecord soeRecord) {
        LambdaQueryWrapper<SoeRecord> query = Wrappers.<SoeRecord>lambdaQuery()
                .eq(SoeRecord::getOrgNo, soeRecord.getOrgNo())
                .eq(SoeRecord::getSoeObjectType, soeRecord.getSoeObjectType())
                .eq(SoeRecord::getSoeObjectId, soeRecord.getSoeObjectId())
                .eq(SoeRecord::getSoeSortNo, soeRecord.getSoeSortNo())
                .eq(SoeRecord::getIsRecovery, false);
        this.baseMapper.update(soeRecord.setSoeRecTime(new Date()).setIsRecovery(true).setSoeGenTime(null), query);
        soeRecord.setSoeRecTime(null).setIsRecovery(false);
    }

}




