package com.gaea.iesms.bm.alarm.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gaea.iesms.bm.alarm.mapper.SoeThresholdSetMapper;
import com.gaea.iesms.bm.alarm.model.request.CeDeviceAlarmSettingRequest;
import com.gaea.iesms.bm.alarm.model.request.SoeThresholdSetRequest;
import com.gaea.iesms.bm.alarm.model.response.vo.SoeThresholdSetVo;
import com.gaea.iesms.bm.alarm.service.SoeThresholdSetService;
import com.gaea.iesms.core.model.entity.alarm.SoeThresholdSet;
import com.gaea.utils.ConvertUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
* @author Administrator
* @description 针对表【soe_threshold_set( )】的数据库操作Service实现
* @createDate 2023-03-21 17:08:58
*/
@Service
public class SoeThresholdSetServiceImpl extends ServiceImpl<SoeThresholdSetMapper, SoeThresholdSet>
    implements SoeThresholdSetService {

    @Resource
    private SoeThresholdSetMapper soeThresholdSetMapper;


    @Override
    public Integer addAlarmDevice(CeDeviceAlarmSettingRequest ceDeviceAlarmSettingRequest) {
        for (String ceDevId : ceDeviceAlarmSettingRequest.getDeviceIds()) {
            List<SoeThresholdSet> addList = Lists.newArrayList();
            List<SoeThresholdSet> delList = Lists.newArrayList();

            for (SoeThresholdSetRequest thresholdSetRequest : ceDeviceAlarmSettingRequest.getDataList()) {
                SoeThresholdSet soeThresholdSet = new SoeThresholdSet();
                BeanUtils.copyProperties(thresholdSetRequest,soeThresholdSet);
                soeThresholdSet.setCeDevId(Long.valueOf(ceDevId));
//                soeThresholdSet.setCreator(userNo);
//                soeThresholdSet.setGmtCreate(System.currentTimeMillis());
//                soeThresholdSet.setModifier(userNo);
//                soeThresholdSet.setGmtModified(System.currentTimeMillis());
                if(!soeThresholdSet.isAlert()) {
                    delList.add(soeThresholdSet);
                }
                addList.add(soeThresholdSet);
            }
            if(ceDeviceAlarmSettingRequest.isShouldDelete() && delList.size() > 0){
                soeThresholdSetMapper.delAlarmDevice(delList);
            }
            if(addList.size() > 0){
                this.addAndUpdateAlarmDevice(addList);
            }
        }
        return null;
    }

    @Override
    public List<SoeThresholdSetVo> findDeviceSetting(String ceDevId) {
        QueryWrapper<SoeThresholdSet> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("ce_dev_id",ceDevId);
        List<SoeThresholdSet> soeThresholdSetList = this.baseMapper.selectList(queryWrapper);
        List<SoeThresholdSetVo> soeThresholdSetVos = ConvertUtils.toList(SoeThresholdSetVo.class, soeThresholdSetList);
        return soeThresholdSetVos;
    }

    private Boolean addAndUpdateAlarmDevice(List<SoeThresholdSet> addList) {
        for (SoeThresholdSet soeThresholdSet : addList) {
            SoeThresholdSet alarmSetOld = this.findAlarmMeasCode(soeThresholdSet.getCeDevId(), soeThresholdSet.getMeasItemCode());
            if (alarmSetOld != null){
                BeanUtils.copyProperties(soeThresholdSet,alarmSetOld,"id","creator","gmtCreate");
                soeThresholdSet.setId(alarmSetOld.getId());
            }
            this.saveOrUpdate(soeThresholdSet);
        }
        return true;
    }

    public SoeThresholdSet findAlarmMeasCode(Long ceDevId,String measCode){
        QueryWrapper<SoeThresholdSet> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("ce_dev_id",ceDevId);
        queryWrapper.eq("meas_item_code",measCode);
        SoeThresholdSet soeThresholdSet = this.baseMapper.selectOne(queryWrapper);
        return soeThresholdSet;
    }
}




