package com.gaea.iesms.bm.alarm.controller;

import com.gaea.base.core.R;
import com.gaea.iesms.bm.alarm.service.ElectricQuantityAlarmService;
import com.gaea.iesms.core.feign.request.alarm.ElectricQuantityAlarmRequest;
import com.gaea.iesms.core.feign.dto.ElectricQuantityAlarmDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author wangxiangzhong
 * @Description 电量告警
 * @Date 2023/03/14/14:15
 */
@Api(tags = "电量告警")
@RestController
@RequestMapping("/electric/quantity")
public class ElectricQuantityAlarmController {

    @Autowired
    private ElectricQuantityAlarmService electricQuantityAlarmService;

    @ApiOperation(value = "插入电量告警")
    @PostMapping("/insertAlarm")
    public R insertElectricQuantityAlarm(@RequestBody ElectricQuantityAlarmRequest electricQuantityAlarmRequest){
        List<ElectricQuantityAlarmDTO> electricQuantityAlarmDTOList = electricQuantityAlarmRequest.getElectricQuantityAlarmList();
        electricQuantityAlarmService.insertElectricQuantityAlarm(electricQuantityAlarmDTOList);
        return R.ok();
    }
}
