package com.gaea.iesms.bm.alarm.controller;

import com.easesource.data.base.ResponseResult;
import com.gaea.base.core.R;
import com.gaea.iesms.bm.alarm.service.*;
import com.gaea.iesms.core.feign.dto.ElectricQuantityAlarmDTO;
import com.gaea.iesms.core.feign.request.alarm.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Author wangxiangzhong
 * @Description 插入告警数据
 * @Date 2023/03/21/9:51
 */
@Api(tags = "插入告警数据")
@RestController
@RequestMapping("/insert/alarm")
public class InsertAlarmController {

    @Resource
    private TerminalWaringService terminalWaringService;

    @Resource
    private SoeRecordService soeRecordService;

    @Resource
    private ElectricQuantityAlarmService electricQuantityAlarmService;

    @Resource
    private CombinerBoxAlarmService combinerBoxAlarmService;

    @Resource
    private EleAlarmService eleAlarmService;


    @Resource
    private InverterAlarmService inverterAlarmService;

    @Resource
    private MeterAlarmService meterAlarmService;

    @Resource
    private VoltageService voltageService;

    @Resource
    private DataCenterAlarmService dataCenterAlarmService;

    @ApiOperation(value = "终端采集告警")
    @PostMapping("/terminalColl")
    public R terminalCollWaring(@RequestBody List<AlarmTerminalGatherWarningRequest> requestList){
        terminalWaringService.terminalCollWaring(requestList);
        return R.ok();
    }

    @ApiOperation(value = "终端故障告警")
    @PostMapping("/terminalFaultAlarm")
    public R terminalFaultAlarm(@RequestBody List<TerminalFaultAlarmRequest> terminalFaultAlarmList){
        terminalWaringService.terminalFaultAlarm(terminalFaultAlarmList);
        return R.ok();
    }
    @ApiOperation(value = "表计采集故障")
    @PostMapping("/meterCollAlarm")
    public R meterCollAlarm(@RequestBody List<MeterCollAlarmRequest> meterCollAlarmRequestList){
        try {
            meterAlarmService.meterCollAlarm(meterCollAlarmRequestList);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return R.ok();
    }

    @ApiOperation(value = "插入电量告警")
    @PostMapping("/electricQuantityAlarm")
    public R insertElectricQuantityAlarm(@RequestBody ElectricQuantityAlarmRequest electricQuantityAlarmRequest){
        List<ElectricQuantityAlarmDTO> electricQuantityAlarmDTOList = electricQuantityAlarmRequest.getElectricQuantityAlarmList();
        electricQuantityAlarmService.insertElectricQuantityAlarm(electricQuantityAlarmDTOList);
        return R.ok();
    }
    @ApiOperation(value = "汇流箱支路断路告警")
    @PostMapping("/combinerBoxBranchCircuitAlarm")
    public R combinerBoxBranchCircuitAlarm(@RequestBody List<CombinerBoxBranchCircuitAlarmRequest> combinerBoxBranchCircuitAlarmRequests){
        combinerBoxAlarmService.combinerBoxBranchCircuitAlarm(combinerBoxBranchCircuitAlarmRequests);
        return R.ok();
    }

    @ApiOperation(value = "电流不平衡")
    @PostMapping("/eleUnBalance")
    public R eleUnBalance(@RequestBody List<EleAlarmRequest> eleAlarmRequestList){
        eleAlarmService.eleUnBalanceAlarm(eleAlarmRequestList);
        return R.ok();
    }
    @ApiOperation(value = "电流失流")
    @PostMapping("/eleErosionFlow")
    public R eleErosionFlow(@RequestBody List<EleAlarmRequest> eleAlarmRequestList){
        //TODO 电流失流
        eleAlarmService.eleErosionFlow(eleAlarmRequestList);
        return R.ok();
    }
    @ApiOperation(value = "电流过流")
    @PostMapping("/eleOverCurrent")
    public R eleOverCurrent(@RequestBody List<EleAlarmRequest> eleAlarmRequestList){
        eleAlarmService.eleOverCurrent(eleAlarmRequestList);
        return R.ok();
    }

    @ApiOperation(value = "逆变器支路断路告警")
    @PostMapping("/inverterBranchCircuitAlarm")
    public R inverterBranchCircuitAlarm(@RequestBody List<InverterAlarmRequest> inverterAlarmRequest){
        try {
            inverterAlarmService.inverterBranchCircuitAlarm(inverterAlarmRequest);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return R.ok();
    }


    @ApiOperation(value = "逆变器MPPT支路断路告警")
    @PostMapping("/inverterMtCircuitAlarm")
    public R inverterMpptCircuitAlarm(@RequestBody List<InverterAlarmRequest> inverterAlarmRequest){
        try {
            inverterAlarmService.inverterMpptCircuitAlarm(inverterAlarmRequest);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return R.ok();
    }

    @ApiOperation(value = "逆变器总线跳闸")
    @PostMapping("/inverterTheBusTripAlarm")
    public R inverterTheBusTripAlarm(@RequestBody List<InverterTheBusTripAlarmRequest> inverterTheBusTripAlarmRequest){
        try {
            inverterAlarmService.inverterTheBusTripAlarm(inverterTheBusTripAlarmRequest);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return R.ok();
    }
    @ApiOperation(value = "间隔电压断相")
    @PostMapping("/voltageOutPhase")
    public R voltageOutPhase(@RequestBody List<VoltageAlarmRequest> voltageAlarmRequestList){
        try {
            voltageService.voltageOutPhase(voltageAlarmRequestList);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return R.ok();
    }
    @ApiOperation(value = "间隔电压越限")
    @PostMapping("/voltageLimit")
    public R voltageLimit(@RequestBody List<VoltageAlarmRequest> voltageAlarmRequestList){
        try {
            voltageService.voltageLimit(voltageAlarmRequestList);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return R.ok();
    }


    @ApiOperation(value = "功率因素异常")
    @PostMapping("/powerFactor")
    public R powerFactor(@RequestBody List<PowerFactorRequest> powerFactorRequestList){
        try {
            voltageService.powerFactor(powerFactorRequestList);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return R.ok();
    }

    @ApiOperation(value = "间隔电压不平衡")
    @PostMapping("/voltageUnBalance")
    public R voltageUnBalance(@RequestBody List<VoltageAlarmRequest> voltageAlarmRequestList){
        try {
            voltageService.voltageUnBalance(voltageAlarmRequestList);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return R.ok();
    }


    @ApiOperation(value = "数据中心业务终端告警")
    @GetMapping("/dataCenterBoundSoeRecord")
    public R updateBoundSoeRecord(){
        try {
            dataCenterAlarmService.dataCenterBoundSoeRecord();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return R.ok();
    }

    @ApiOperation(value = "数据中心设备表计告警")
    @PostMapping("/dataCenterDevMeterAlarm")
    public R dataCenterDevMeterAlarm(@RequestBody List<SoeRecordOnOffAlarmRequest> soeRecordOnOffAlarmRequestList){
        try {
            dataCenterAlarmService.dataCenterDevMeterAlarm(soeRecordOnOffAlarmRequestList);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return R.ok();
    }
}
