package com.gaea.iesms.bm.alarm.controller;

import com.gaea.base.core.R;
import com.gaea.iesms.bm.alarm.service.SoeRecordService;
import com.gaea.iesms.core.feign.request.alarm.PushAlarmRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author wxz
 * @description: TODO
 */
@Api(tags = "业务推送告警数据")
@RestController
@RequestMapping("/push")
public class PushAlarmController {

    @Resource
    private SoeRecordService soeRecordService;

    @ApiOperation(value = "告警推送")
    @PostMapping("/alarm")
    public R pushAlarm(@RequestBody PushAlarmRequest pushAlarmRequest){
        soeRecordService.pushAlarm(pushAlarmRequest);
        return R.ok();
    }
}
