package com.gaea.iesms.bm.alarm.controller;

import com.gaea.base.core.R;
import com.gaea.iesms.core.feign.request.alarm.AlarmRecordPageRequest;
import com.gaea.iesms.bm.alarm.model.response.dto.SoeRecordDto;
import com.gaea.iesms.bm.alarm.model.request.AlarmObjectPageRequest;
import com.gaea.iesms.core.feign.response.alarm.SoeRecordPageVo;
import com.gaea.iesms.core.feign.response.alarm.SoeRecordVo;
import com.gaea.iesms.bm.alarm.service.SoeRecordHandleService;
import com.gaea.iesms.bm.alarm.service.SoeRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @Author wangxiangzhong
 * @Description 告警表查询
 * @Date 2023/03/13/11:14
 */

@Api(tags = "告警记录管理")
@RestController
@RequestMapping("/alarm")
public class SoeRecordController {

    @Resource
    private SoeRecordService soeRecordService;

    @Resource
    private SoeRecordHandleService soeRecordHandleService;


     @ApiOperation(value = "告警记录列表查询")
     @PostMapping("/listSoeRecord")
     public R<SoeRecordPageVo> listSoeRecord(@RequestBody AlarmRecordPageRequest alarmRecordPageRequest){
         SoeRecordPageVo soeRecordPage  =  soeRecordService.listSoeRecord(alarmRecordPageRequest);
         return R.ok(soeRecordPage);
     }
    @GetMapping(value = "/confirmSubscribeAlarm")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "告警事件标识", dataType = "String", required = true),
            @ApiImplicitParam(name = "archiveDesc", value = "归档说明", dataType = "String", required = false)
    })
    @ApiOperation("研判确认")
    public R insertSoeRecordHandle(@RequestParam(value = "id",required = true) String id,
                                   @RequestParam(value = "archiveDesc",required = false) String archiveDesc) {

        int result = soeRecordHandleService.insertSoeRecordHandle(id, archiveDesc);
        if (result >0){
            return R.ok();
        }
        return R.failure();
    }
    @ApiOperation(value = "根据告警对象id查询告警")
    @PostMapping("getSoeRecordByObjectId")
    public R<SoeRecordPageVo> getSoeRecordByObjectId(@RequestBody AlarmObjectPageRequest alarmObjectPageRequest){
        SoeRecordPageVo soeRecordByObject = soeRecordService.getSoeRecordByObjectId(alarmObjectPageRequest);
        return R.ok(soeRecordByObject);
    }

    @ApiOperation(value = "根据告警id查询详情")
    @GetMapping("/getSoeRecordById")
    public R<SoeRecordVo> getSoeRecordById(@RequestParam(value = "id") Long id){
       SoeRecordDto soeRecordDto =  soeRecordService.findSoeRecordById(id);
       SoeRecordVo soeRecordVo = new SoeRecordVo();
        BeanUtils.copyProperties(soeRecordDto,soeRecordVo);
       return R.ok(soeRecordVo);
    }
}
