package com.gaea.iesms.bm.alarm.controller;


import com.gaea.base.core.R;
import com.gaea.iesms.core.feign.request.alarm.CeDeviceAlarmSetting;
import com.gaea.iesms.core.feign.request.alarm.CeDeviceAlarmSettingRequest;
import com.gaea.iesms.bm.alarm.model.response.vo.SoeThresholdSetVo;
import com.gaea.iesms.bm.alarm.service.SoeThresholdSetService;
import com.gaea.iesms.core.feign.request.alarm.CeDeviceAlarmVo;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Author wangxiangzhong
 * @Description 告警设置
 * @Date 2023/04/27/15:50
 */
@Api(tags = "告警设置")
@RestController
@RequestMapping("/soe/thresholdSet")
public class SoeThresholdSetController {


    @Resource
    private SoeThresholdSetService soeThresholdSetService;


    @PostMapping(value = "/addDeviceSettingss")
    @ResponseBody
    @ApiOperation("新增告警表单设置参数")
    public R addDeviceSettingss(@RequestBody CeDeviceAlarmSettingRequest ceDeviceAlarmSettingRequest){
        Integer flag =soeThresholdSetService.addAlarmDevice(ceDeviceAlarmSettingRequest);
        return R.ok();
    }

    @PostMapping(value = "/addDeviceSetting")
    @ResponseBody
    @ApiOperation("新增告警表单设置参数")
    public R addDeviceSetting(@RequestBody CeDeviceAlarmSetting ceDeviceAlarmSetting) {
        Integer flag = soeThresholdSetService.addDeviceSetting(ceDeviceAlarmSetting);
        return R.ok();
    }



    @GetMapping(value = "/findDeviceSetting")
    @ApiOperation("通过间隔id获取告警设置返回值")
    @ApiImplicitParam(name = "ceDevId", value = "设备id", dataType = "String", required = true)
    public R findDeviceSetting(String ceDevId){
        List<SoeThresholdSetVo>   soeThresholdSetList = soeThresholdSetService.findDeviceSetting(ceDevId);
        return R.ok(soeThresholdSetList);
    }


    @GetMapping(value = "/finDevice")
    @ApiOperation("点击树上的层级 返回该节点下所有的间隔")
    public R finDevice(CeDeviceAlarmVo ceDeviceAlarmVo){
        Map<String,Object> map = Maps.newHashMap();
        List<CeDeviceAlarmVo> list;
        if (ceDeviceAlarmVo.getType() == 1) {
            list= soeThresholdSetService.findDevice(ceDeviceAlarmVo);
        } else {
            list= soeThresholdSetService.findContainer(ceDeviceAlarmVo);
        }
        map.put("total",list.size());
        map.put("list",list);
        return R.ok(map);
    }

}
