package com.gaea.iesms.bm.alarm.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeGenValueJsonObject;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeRecValueJsonObject;
import com.gaea.base.typehandler.JsonObjectTypeHandler;
import lombok.Data;

import java.util.Date;

/**
 * @Author wangxiangzhong
 * @Description TODO
 * @Date 2023/03/21/13:38
 */
@Data
public class SoeRecordSaveDto {

    private String orgNo;

    /**
     * 事件对象标识
     */
    private Long soeObjectId;

    /**
     * 事件对象名称
     */
    private String soeObjectName;

    /**
     * 事件分类编号
     */
    private String soeSortNo;
    /**
     * 事件等级 1 - 一般事件；2 - 次要事件；3 - 重要事件；
     */
    private Integer soeLevel;

    /**
     * 严重等级 1 - 轻微；2 - 普通；3 - 严重；
     */
    private Integer graveLevel;

    /**
     * 事件标题
     */
    private String soeTitle;

    /**
     * 事件说明
     */
    private String soeDesc;

    /**
     * 事件发生时间
     */
    private Date soeGenTime;

    /**
     * 事件发生值
     */
    @TableField(value = "soe_gen_value", typeHandler = JsonObjectTypeHandler.class)
    private SoeGenValueJsonObject soeGenValue;

    /**
     * 是否复归
     */
    private Boolean isRecovery;

    /**
     * 事件复归时间
     */
    private Date soeRecTime;

    /**
     * 事件复归值
     */
    @TableField(value = "soe_rec_value", typeHandler = JsonObjectTypeHandler.class)
    private SoeRecValueJsonObject soeRecValue;


}
