package com.gaea.iesms.bm.alarm.model.request;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "UpdateSubsInfoRequest", description = "告警订阅修改")
public class UpdateSubsInfoRequest {


    private String id;

    /**
     * 系统单位编号
     */
    @ApiModelProperty("系统单位编号")
    private String orgNo;

    /** 是否系统铃声报警 */
    @ApiModelProperty("是否系统铃声报警")
    private boolean sysBellAlarm ;

    /** 是否手机短信通知 */
    @ApiModelProperty("是否手机短信通知 true是 false否")
    private boolean mobileSmsNtfy ;

    @ApiModelProperty(value = "手机短信通知配置信息 手机号码列表字符串（分隔符为,）",example = "13777777777,13888888888")
    private String mobileSmsNtfyConfig ;
    /** 是否手机语音通知 */
    @ApiModelProperty(value = "是否手机语音通知 true是 false否")
    private boolean mobileVoiceNtfy ;

    @ApiModelProperty(value = "手机语音通知配置信息 手机号码列表字符串（分隔符为,）",example = "13777777777,13888888888")
    private String mobileVoiceNtfyConfig ;
//    /** all | soe_sort_no_list - 所有 | 事件分类编号列表  **/
//    private String soeFilterConfig;
    /**
     * 严重告警铃声URL
     */
    @ApiModelProperty(value = "严重告警铃声URL")
    private String seriousAlarmBellUrl;
    /**
     * 普通告警铃声URL
     */
    @ApiModelProperty(value = "普通告警铃声URL")
    private String generalAlarmBellUrl;
    /**
     *轻微告警铃声URL
     */
    @ApiModelProperty(value = "轻微告警铃声URL")
    private String slightAlarmBellUrl;
    /**
     * all | soe_sort_no_list - 所有 | 事件分类编号列表
     */
    @ApiModelProperty(value = "事件分类编号列表")
    private String soeFilterType;
    /**
     * 告警分类列表
     */
    @ApiModelProperty(value = "告警分类列表")
    private List<String> soeSortNoList;

}
