package com.gaea.iesms.bm.alarm.model.response.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * @Author wangxiangzhong
 * @Description TODO
 * @Date 2023/03/21/14:16
 */
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class AlarmDto implements Serializable {
    private static final long serialVersionUID = -2104456692875925976L;

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 设备名称  标识什么设备的告警  例：广孚中心2708提拇终端02
     */
    private String deviceName;

    /**
     * 告警的类型  表示什么告警  例： SOE_TERM_COMM_FAILURE
     */
    private String soeSortNo;

    /**
     * 告警类型  表示什么告警 例：采集终端通讯故障
     */
    private String soeSortName;

    /**
     * 告警等级   区分告警  1 - 轻微；2 - 普通；3 - 严重；
     */
    private Integer graveLevel;
}
