package com.gaea.iesms.bm.alarm.model.response.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.gaea.base.typehandler.JsonObjectTypeHandler;
import com.gaea.iesms.core.model.jsonobject.alarm.MobileSmsNtfyConfigJsonObject;
import com.gaea.iesms.core.model.jsonobject.alarm.MobileVoiceNtfyConfigJsonObject;
import com.gaea.iesms.core.model.jsonobject.alarm.SoeFilterConfigJsonObject;
import com.gaea.iesms.core.model.jsonobject.alarm.SysBellAlarmConfigJsonObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author wangxiangzhong
 * @Description 告警订阅信息返回信息
 * @Date 2023/03/27/11:11
 */
@Data
public class OpsSubsInfoVo {

    @ApiModelProperty(value = "订阅id")
    private Long id;

    @ApiModelProperty(value = "系统单位编号")
    private String orgNo;

    @ApiModelProperty(value = "用能客户标识")
    private Long ceCustId;

    @ApiModelProperty(value = "是否系统铃声报警")
    private boolean isSysBellAlarm;

    @ApiModelProperty(value = "系统铃声报警配置信息")
    private SysBellAlarmConfigJsonObject sysBellAlarmConfig;

    @ApiModelProperty(value = "是否手机短信通知")
    private boolean isMobileSmsNtfy;

    @ApiModelProperty(value = "手机短信通知配置信息")
    private MobileSmsNtfyConfigJsonObject mobileSmsNtfyConfig;

    @ApiModelProperty(value = "是否手机语音通知")
    private boolean isMobileVoiceNtfy;

    @ApiModelProperty(value = "手机语音通知配置信息")
    private MobileVoiceNtfyConfigJsonObject mobileVoiceNtfyConfig;

    @ApiModelProperty(value = "告警过滤配置信息")
    private SoeFilterConfigJsonObject soeFilterConfig;

    @ApiModelProperty(value = "告警数据项名称")
    private List<String> sortNameList;
}
