package com.gaea.iesms.bm.alarm.model.response.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @Author wangxiangzhong
 * @Description 告警设置
 * @Date 2023/04/28/10:55
 */
@ApiModel(description = "告警设置")
@Data
public class SoeThresholdSetVo {
    @ApiModelProperty(value = "设备ID", required = true)
    private Long ceDevId;

    @ApiModelProperty(value = "数据项编码", required = true)
    private String measItemCode;

    @ApiModelProperty(value = "设备类型", required = true)
    private String ceResSortNo;

    @ApiModelProperty(value = "数据项名称", required = true)
    private String measItemAlias;

    @ApiModelProperty(value = "越上限值")
    private BigDecimal upperLimit;

    @ApiModelProperty(value = "越上上限值")
    private BigDecimal upperUpperLimit;

    @ApiModelProperty(value = "越下限值")
    private BigDecimal downLimit;

    @ApiModelProperty(value = "越下下限值")
    private BigDecimal downDownLimit;

    @ApiModelProperty(value = "是否告警")
    private boolean isAlert;
}
